/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.giraffe;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.giraffe.GiraffeAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GiraffeEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.giraffe.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.giraffe.walk");
    private static final RawAnimation GRAZING = RawAnimation.begin().then("animation.giraffe.grazing", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_GRAZE = RawAnimation.begin().thenLoop("animation.giraffe.idle_graze");
    private static final RawAnimation GETTING_UP = RawAnimation.begin().then("animation.giraffe.getting_up", Animation.LoopType.PLAY_ONCE);
    private static final EntityDataAccessor<Integer> GRAZE_STATE = SynchedEntityData.defineId(GiraffeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int GRAZE_TRANSITION_TICKS = 15;
    public static final UniformInt GRAZE_DURATION = UniformInt.of((int)200, (int)400);
    public static final UniformInt GRAZE_COOLDOWN = UniformInt.of((int)200, (int)400);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int grazeTime;
    public int grazeCooldown;

    public GiraffeEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
    }

    public boolean isGrazing() {
        GrazeState state = this.getGrazeState();
        return state == GrazeState.GRAZING_DOWN || state == GrazeState.GRAZING || state == GrazeState.GETTING_UP;
    }

    public GrazeState getGrazeState() {
        return GrazeState.byId((Integer)this.entityData.get(GRAZE_STATE));
    }

    public void setGrazeState(GrazeState state) {
        this.entityData.set(GRAZE_STATE, (Object)state.ordinal());
    }

    protected void customServerAiStep() {
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("giraffeBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("giraffeActivityUpdate");
        GiraffeAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    protected Brain.Provider<GiraffeEntity> brainProvider() {
        return GiraffeAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return GiraffeAI.makeBrain((Brain<GiraffeEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.GIRAFFE_FOOD);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ReAnimalSoundEvents.GIRAFFE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ReAnimalSoundEvents.GIRAFFE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ReAnimalSoundEvents.GIRAFFE_DEATH.get();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        GiraffeEntity baby = (GiraffeEntity)((EntityType)ReAnimalEntities.GIRAFFE.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(GRAZE_STATE, (Object)GrazeState.STANDING.ordinal());
    }

    public void aiStep() {
        super.aiStep();
        if (this.isGrazing()) {
            this.setXRot(0.0f);
            this.xRotO = 0.0f;
            this.yHeadRot = this.yBodyRot;
            this.yHeadRotO = this.yBodyRotO;
        }
        if (!this.level().isClientSide && this.isGrazing()) {
            this.getNavigation().stop();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("GrazeState", ((Integer)this.entityData.get(GRAZE_STATE)).intValue());
        tag.putInt("GrazeTime", this.grazeTime);
        tag.putInt("GrazeCooldown", this.grazeCooldown);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("GrazeState")) {
            this.setGrazeState(GrazeState.byId(tag.getInt("GrazeState")));
        }
        if (tag.contains("GrazeTime")) {
            this.grazeTime = tag.getInt("GrazeTime");
        }
        if (tag.contains("GrazeCooldown")) {
            this.grazeCooldown = tag.getInt("GrazeCooldown");
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result) {
            this.getBrain().setMemory(MemoryModuleType.IS_PANICKING, (Object)true);
            GiraffeAI.updateActivity(this);
        }
        return result;
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (GiraffeEntity.this.isGrazing()) {
                    return;
                }
                super.clientTick();
            }
        };
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<GiraffeEntity> state) {
        AnimationController controller = state.getController();
        switch (this.getGrazeState().ordinal()) {
            case 1: {
                controller.setAnimation(GRAZING);
                break;
            }
            case 2: {
                controller.setAnimation(IDLE_GRAZE);
                break;
            }
            case 3: {
                controller.setAnimation(GETTING_UP);
                break;
            }
            case 0: {
                if (state.isMoving()) {
                    controller.setAnimation(WALK);
                    break;
                }
                controller.setAnimation(IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.STEP_HEIGHT, 1.1);
    }

    public boolean canStartGrazing() {
        return !this.isVehicle() && !this.isInWaterOrBubble() && !this.getNavigation().isInProgress() && this.getDeltaMovement().horizontalDistanceSqr() < 1.0E-4 && !this.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING) && !this.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) && !this.getBrain().hasMemoryValue(MemoryModuleType.IS_TEMPTED) && this.random.nextInt(400) == 0;
    }

    public void startGrazingDown() {
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.setGrazeState(GrazeState.GRAZING_DOWN);
        this.grazeTime = 15;
    }

    public void startGettingUp() {
        this.setGrazeState(GrazeState.GETTING_UP);
        this.grazeTime = 15;
    }

    public void finishGettingUp() {
        this.setGrazeState(GrazeState.STANDING);
        this.grazeCooldown = GRAZE_COOLDOWN.sample(this.random);
    }

    public static enum GrazeState {
        STANDING,
        GRAZING_DOWN,
        GRAZING,
        GETTING_UP;


        public static GrazeState byId(int id) {
            GrazeState[] values = GrazeState.values();
            return id >= 0 && id < values.length ? values[id] : STANDING;
        }
    }
}

