/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.giraffe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.giraffe.GiraffeEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSensorTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class GiraffeAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super GiraffeEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)ReAnimalSensorTypes.GIRAFFE_TEMPTATIONS.get()), (Object)SensorType.NEAREST_ADULT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY});

    public static Brain.Provider<GiraffeEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<GiraffeEntity> brain) {
        GiraffeAI.initCoreActivity(brain);
        GiraffeAI.initIdleActivity(brain);
        GiraffeAI.initPanicActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<GiraffeEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new GrazeCooldownBehavior()), (Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<GiraffeEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GrazeBehavior())), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new AnimalMakeLove((EntityType)ReAnimalEntities.GIRAFFE.get(), 1.0f, 1)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)10), (float)1.25f), (Object)1)))), (Object)Pair.of((Object)4, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initPanicActivity(Brain<GiraffeEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.PANIC, 10, ImmutableList.of((Object)new AnimalPanic(1.5f, mob -> DamageTypeTags.PANIC_CAUSES)), MemoryModuleType.IS_PANICKING);
    }

    public static void updateActivity(GiraffeEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(ReAnimalTags.Items.GIRAFFE_FOOD);
    }

    public static class GrazeCooldownBehavior
    extends Behavior<GiraffeEntity> {
        public GrazeCooldownBehavior() {
            super((Map)ImmutableMap.of(), 1200);
        }

        protected boolean canStillUse(ServerLevel level, GiraffeEntity entity, long gameTime) {
            return true;
        }

        protected void tick(ServerLevel level, GiraffeEntity entity, long gameTime) {
            if (entity.grazeCooldown > 0) {
                --entity.grazeCooldown;
            }
        }
    }

    public static class GrazeBehavior
    extends Behavior<GiraffeEntity> {
        public GrazeBehavior() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 1200);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, GiraffeEntity entity) {
            return entity.grazeCooldown == 0 && entity.canStartGrazing();
        }

        protected void start(ServerLevel level, GiraffeEntity entity, long gameTime) {
            entity.startGrazingDown();
        }

        protected boolean canStillUse(ServerLevel level, GiraffeEntity entity, long gameTime) {
            return entity.getGrazeState() != GiraffeEntity.GrazeState.STANDING;
        }

        protected void tick(ServerLevel level, GiraffeEntity entity, long gameTime) {
            boolean shouldAbort;
            Brain brain = entity.getBrain();
            GiraffeEntity.GrazeState grazeState = entity.getGrazeState();
            boolean bl = shouldAbort = brain.hasMemoryValue(MemoryModuleType.IS_PANICKING) || brain.hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) || brain.hasMemoryValue(MemoryModuleType.IS_TEMPTED) || entity.isInWaterOrBubble();
            if ((grazeState == GiraffeEntity.GrazeState.GRAZING_DOWN || grazeState == GiraffeEntity.GrazeState.GRAZING) && shouldAbort) {
                entity.startGettingUp();
                grazeState = entity.getGrazeState();
            }
            switch (grazeState) {
                case GRAZING_DOWN: {
                    if (--entity.grazeTime > 0) break;
                    entity.grazeTime = GiraffeEntity.GRAZE_DURATION.sample(entity.getRandom());
                    entity.setGrazeState(GiraffeEntity.GrazeState.GRAZING);
                    break;
                }
                case GRAZING: {
                    entity.getNavigation().stop();
                    if (--entity.grazeTime > 0) break;
                    entity.startGettingUp();
                    break;
                }
                case GETTING_UP: {
                    if (--entity.grazeTime > 0) break;
                    entity.finishGettingUp();
                    break;
                }
            }
        }

        protected void stop(ServerLevel level, GiraffeEntity entity, long gameTime) {
            if (entity.getGrazeState() != GiraffeEntity.GrazeState.STANDING) {
                entity.finishGettingUp();
            }
        }
    }
}

