/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.sound;

import it.hurts.shatterbyte.reanimal.common.entity.butterfly.ButterflyEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSoundEvents;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButterflySoundInstance
extends AbstractTickableSoundInstance {
    private static final float VOLUME_MAX = 0.9f;
    private static final float SPEED_MIN = 0.01f;
    private final ButterflyEntity butterfly;

    public ButterflySoundInstance(ButterflyEntity butterfly) {
        super((SoundEvent)ReAnimalSoundEvents.BUTTERFLY_LOOP.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.butterfly = butterfly;
        this.x = (float)butterfly.getX();
        this.y = (float)butterfly.getY();
        this.z = (float)butterfly.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
    }

    public void tick() {
        if (!this.butterfly.isAlive() || this.butterfly.isRemoved()) {
            this.stop();
            return;
        }
        this.x = (float)this.butterfly.getX();
        this.y = (float)this.butterfly.getY();
        this.z = (float)this.butterfly.getZ();
        if (this.butterfly.onGround()) {
            this.pitch = 0.0f;
            this.volume = 0.0f;
            return;
        }
        float speed = (float)this.butterfly.getDeltaMovement().horizontalDistance();
        if (speed >= 0.01f) {
            this.pitch = Mth.lerp((float)Mth.clamp((float)speed, (float)this.getMinPitch(), (float)this.getMaxPitch()), (float)this.getMinPitch(), (float)this.getMaxPitch());
            this.volume = Mth.lerp((float)Mth.clamp((float)speed, (float)0.0f, (float)0.5f), (float)0.0f, (float)0.9f);
        } else {
            this.pitch = 0.0f;
            this.volume = 0.0f;
        }
    }

    private float getMinPitch() {
        return this.butterfly.isBaby() ? 1.3f : 0.9f;
    }

    private float getMaxPitch() {
        return this.butterfly.isBaby() ? 1.6f : 1.2f;
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return !this.butterfly.isSilent();
    }
}

