/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.renderer.glow_stick;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.hurts.shatterbyte.reanimal.client.model.glow_stick.GlowStickModel;
import it.hurts.shatterbyte.reanimal.common.entity.glow_stick.GlowStickEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class GlowStickRenderer
extends GeoEntityRenderer<GlowStickEntity> {
    public GlowStickRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GlowStickModel());
    }

    public RenderType getRenderType(GlowStickEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutout((ResourceLocation)texture);
    }

    public void actuallyRender(PoseStack poseStack, GlowStickEntity animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, 0xF000F0, packedOverlay, colour);
    }

    protected void applyRotations(GlowStickEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float scale) {
        poseStack.translate(0.0f, 0.3125f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.getRenderYaw(partialTick)));
        poseStack.mulPose(Axis.ZP.rotationDegrees(entity.getRenderPitch(partialTick)));
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getRenderRoll(partialTick)));
        poseStack.translate(0.0f, -0.3125f, 0.0f);
    }
}

