/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.model.pigeon;

import it.hurts.shatterbyte.reanimal.common.entity.pigeon.PigeonEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class PigeonModel
extends GeoModel<PigeonEntity> {
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"geo/pigeon.geo.json");
    private static final ResourceLocation TEXTURE_ADULT = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/pigeon_adult.png");
    private static final ResourceLocation TEXTURE_BABY = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/pigeon_baby.png");
    private static final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"animations/pigeon.animation.json");

    public ResourceLocation getModelResource(PigeonEntity entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(PigeonEntity entity) {
        return entity.isBaby() ? TEXTURE_BABY : TEXTURE_ADULT;
    }

    public ResourceLocation getAnimationResource(PigeonEntity entity) {
        return ANIMATION;
    }

    public void setCustomAnimations(PigeonEntity animatable, long instanceId, AnimationState<PigeonEntity> state) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, state);
        if (animatable.isPecking()) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head == null) {
            return;
        }
        EntityModelData modelData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
        float headYaw = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float headPitch = modelData.headPitch() * ((float)Math.PI / 180);
        head.setRotY(headYaw);
        head.setRotX(headPitch);
    }
}

