/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.model.ostrich;

import it.hurts.shatterbyte.reanimal.common.entity.ostrich.OstrichEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OstrichModel
extends GeoModel<OstrichEntity> {
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"geo/ostrich.geo.json");
    private static final ResourceLocation TEXTURE_ADULT = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/ostrich_adult.png");
    private static final ResourceLocation TEXTURE_BABY = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/ostrich_baby.png");
    private static final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"animations/ostrich.animation.json");

    public ResourceLocation getModelResource(OstrichEntity entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OstrichEntity entity) {
        return entity.isBaby() ? TEXTURE_BABY : TEXTURE_ADULT;
    }

    public ResourceLocation getAnimationResource(OstrichEntity entity) {
        return ANIMATION;
    }

    public void setCustomAnimations(OstrichEntity animatable, long instanceId, AnimationState<OstrichEntity> state) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, state);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head == null) {
            return;
        }
        EntityModelData modelData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
        float headYaw = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float headPitch = modelData.headPitch() * ((float)Math.PI / 180);
        head.setRotY(headYaw);
        head.setRotX(headPitch);
    }
}

