/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EggItem<T extends ThrowableItemProjectile>
extends net.minecraft.world.item.EggItem {
    private final Supplier<EntityType<T>> projectile;

    public EggItem(Item.Properties properties, Supplier<EntityType<T>> projectile) {
        super(properties);
        this.projectile = projectile;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ThrowableItemProjectile projectile;
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide() && (projectile = (ThrowableItemProjectile)this.projectile.get().create(level)) instanceof ThrowableItemProjectile) {
            ThrowableItemProjectile egg = projectile;
            egg.setItem(stack);
            egg.setOwner((Entity)player);
            egg.setPos(player.getEyePosition());
            egg.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)egg);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

