/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.seal;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.seal.SealAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SealEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.seal.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.seal.walk");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.seal.swim");
    private static final RawAnimation LAYING = RawAnimation.begin().then("animation.seal.laying", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation LAY = RawAnimation.begin().thenLoop("animation.seal.lay");
    private static final RawAnimation LAY_SLAP = RawAnimation.begin().thenLoop("animation.seal.lay_slap");
    private static final RawAnimation GETTING_UP = RawAnimation.begin().then("animation.seal.getting_up", Animation.LoopType.PLAY_ONCE);
    private static final EntityDataAccessor<Integer> LAY_STATE = SynchedEntityData.defineId(SealEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int LAY_TRANSITION_TICKS = 14;
    public static final UniformInt LAY_DURATION = UniformInt.of((int)400, (int)800);
    private static final UniformInt LAY_COOLDOWN = UniformInt.of((int)200, (int)400);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int layTime;
    public int layCooldown;
    @Nullable
    private BlockPos environmentTarget;

    public SealEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 1.0f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = new AmphibiousPathNavigation((Mob)this, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void setEnvironmentTarget(@Nullable BlockPos pos) {
        this.environmentTarget = pos;
    }

    @Nullable
    public BlockPos getEnvironmentTarget() {
        return this.environmentTarget;
    }

    public boolean hasEnvironmentTarget() {
        return this.environmentTarget != null;
    }

    public void clearEnvironmentTarget() {
        this.environmentTarget = null;
    }

    public boolean isAtEnvironmentTarget() {
        if (this.environmentTarget == null) {
            return false;
        }
        return this.blockPosition().closerThan((Vec3i)this.environmentTarget, 2.0);
    }

    protected void customServerAiStep() {
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("sealBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("sealActivityUpdate");
        SealAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (this.isLaying()) {
            this.setXRot(0.0f);
            this.xRotO = 0.0f;
            this.yHeadRot = this.yBodyRot;
            this.yHeadRotO = this.yBodyRotO;
        }
        if (!this.level().isClientSide && this.isLaying()) {
            this.getNavigation().stop();
        }
    }

    protected Brain.Provider<SealEntity> brainProvider() {
        return SealAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return SealAI.makeBrain((Brain<SealEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.SEAL_FOOD);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        SealEntity baby = (SealEntity)((EntityType)ReAnimalEntities.SEAL.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result) {
            this.getBrain().setMemory(MemoryModuleType.IS_PANICKING, (Object)true);
            SealAI.updateActivity(this);
        }
        return result;
    }

    public void updateSwimming() {
        this.setSwimming(this.isEffectiveAi() && this.isInWaterOrBubble());
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWaterOrBubble() && this.isSwimming()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.horizontalCollision) {
                this.setDeltaMovement(this.getDeltaMovement().x, 0.3, this.getDeltaMovement().z);
            }
        } else {
            super.travel(travelVector);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<SealEntity> state) {
        AnimationController controller = state.getController();
        SealEntity entity = (SealEntity)state.getAnimatable();
        switch (this.getLayState().ordinal()) {
            case 1: {
                controller.setAnimation(LAYING);
                break;
            }
            case 2: {
                if (entity.level().getNearestPlayer((Entity)this, 3.0) != null) {
                    controller.setAnimation(LAY_SLAP);
                    break;
                }
                controller.setAnimation(LAY);
                break;
            }
            case 3: {
                controller.setAnimation(GETTING_UP);
                break;
            }
            case 0: {
                if (state.isMoving()) {
                    if (this.isInWater()) {
                        controller.setAnimation(SWIM);
                        break;
                    }
                    controller.setAnimation(WALK);
                    break;
                }
                controller.setAnimation(IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(NeoForgeMod.SWIM_SPEED, 0.75).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.STEP_HEIGHT, 1.1).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(LAY_STATE, (Object)LayState.STANDING.ordinal());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("LayState", ((Integer)this.entityData.get(LAY_STATE)).intValue());
        tag.putInt("LayTime", this.layTime);
        tag.putInt("LayCooldown", this.layCooldown);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("LayState")) {
            this.setLayState(LayState.byId(tag.getInt("LayState")));
        }
        if (tag.contains("LayTime")) {
            this.layTime = tag.getInt("LayTime");
        }
        if (tag.contains("LayCooldown")) {
            this.layCooldown = tag.getInt("LayCooldown");
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (SealEntity.this.isLaying()) {
                    return;
                }
                super.clientTick();
            }
        };
    }

    public boolean isLaying() {
        LayState state = this.getLayState();
        return state == LayState.LAYING_DOWN || state == LayState.LAYING || state == LayState.GETTING_UP;
    }

    public LayState getLayState() {
        return LayState.byId((Integer)this.entityData.get(LAY_STATE));
    }

    public void setLayState(LayState state) {
        this.entityData.set(LAY_STATE, (Object)state.ordinal());
    }

    public boolean canStartLaying() {
        return !this.isVehicle() && !this.isInWaterOrBubble() && !this.getNavigation().isInProgress() && this.getDeltaMovement().horizontalDistanceSqr() < 1.0E-4 && !this.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING) && !this.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) && this.random.nextInt(600) == 0;
    }

    public void startLayingDown() {
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.setLayState(LayState.LAYING_DOWN);
        this.layTime = 14;
    }

    public void startGettingUp() {
        this.setLayState(LayState.GETTING_UP);
        this.layTime = 14;
    }

    public void finishGettingUp() {
        this.setLayState(LayState.STANDING);
        this.layCooldown = LAY_COOLDOWN.sample(this.random);
    }

    public static enum LayState {
        STANDING,
        LAYING_DOWN,
        LAYING,
        GETTING_UP;


        public static LayState byId(int id) {
            LayState[] values = LayState.values();
            return id >= 0 && id < values.length ? values[id] : STANDING;
        }
    }
}

