/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.pigeon;

import com.mojang.serialization.Dynamic;
import it.hurts.shatterbyte.reanimal.common.entity.pigeon.PigeonAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalItems;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PigeonEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.pigeon.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.pigeon.walk");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.pigeon.fly");
    private static final RawAnimation PECK = RawAnimation.begin().thenLoop("animation.pigeon.peck");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private long scaredTicks;
    private int peckTicks;
    private int peckCooldown;
    private int eggTime = this.random.nextInt(6000) + 6000;

    public PigeonEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.updateMoveControl();
        this.getNavigation().setCanFloat(true);
    }

    public boolean isPecking() {
        return this.peckTicks > 0;
    }

    public boolean isScared() {
        return this.scaredTicks > 0L;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanPassDoors(true);
        navigation.setCanFloat(true);
        return navigation;
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            super.customServerAiStep();
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.tickScared(serverLevel);
        if (!this.isScared()) {
            ProfilerFiller profiler = serverLevel.getProfiler();
            profiler.push("pigeonBrain");
            this.getBrain().tick(serverLevel, (LivingEntity)this);
            profiler.pop();
            profiler.push("pigeonActivityUpdate");
            PigeonAI.updateActivity(this);
            profiler.pop();
        }
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.onGround()) {
            Vec3 motion = this.getDeltaMovement();
            if (motion.y < -0.1) {
                this.setDeltaMovement(motion.x, -0.1, motion.z);
            }
        }
        if (this.isPecking()) {
            float bodyYaw;
            this.yBodyRot = bodyYaw = this.getYRot();
            this.yHeadRot = bodyYaw;
            this.setXRot(0.0f);
        }
        if (this.level().isClientSide()) {
            if (this.onGround() && !this.isScared() && this.getDeltaMovement().horizontalDistanceSqr() < 1.0E-4) {
                if (this.peckTicks > 0) {
                    --this.peckTicks;
                } else if (this.peckCooldown > 0) {
                    --this.peckCooldown;
                } else if (this.random.nextInt(120) == 0) {
                    this.peckTicks = 60;
                    this.peckCooldown = 40 + this.random.nextInt(60);
                }
            } else {
                this.peckTicks = 0;
            }
        }
    }

    public void setBaby(boolean baby) {
        super.setBaby(baby);
        this.updateMoveControl();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("eggTime", this.eggTime);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.eggTime = tag.contains("eggTime") ? tag.getInt("eggTime") : this.random.nextInt(6000) + 6000;
        this.updateMoveControl();
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        this.tickEggLaying();
        if (this.scaredTicks > 0L) {
            --this.scaredTicks;
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (PigeonEntity.this.isPecking()) {
                    return;
                }
                super.clientTick();
            }
        };
    }

    private void tickScared(ServerLevel level) {
        LivingEntity scary = null;
        for (LivingEntity entity2 : level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(7.0, 3.0, 7.0), entity -> entity != this)) {
            if (!this.isScaredBy(entity2)) continue;
            scary = entity2;
            break;
        }
        if (scary == null) {
            return;
        }
        this.scaredTicks = 100L;
        if (this.getNavigation().isDone()) {
            Vec3 away;
            Vec3 dir = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
            if (dir.dot(away = this.position().subtract(scary.position()).multiply(1.0, 0.0, 1.0).normalize()) < 0.0) {
                dir = dir.scale(-1.0);
            }
            dir = away.scale(0.5).add(dir.scale(0.5)).normalize();
            Vec3 center = this.position().add(dir.scale(16.0));
            BlockPos ground = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlockPos.containing((Position)center));
            Vec3 target = ground.getCenter();
            this.getNavigation().moveTo(target.x, target.y, target.z, 1.0);
        }
    }

    public void updateMoveControl() {
        if (this.isBaby()) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
        } else {
            this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
            this.navigation = new FlyingPathNavigation((Mob)this, this.level());
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.resetFallDistance();
    }

    protected Brain.Provider<PigeonEntity> brainProvider() {
        return PigeonAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PigeonAI.makeBrain((Brain<PigeonEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.PIGEON_FOOD);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        PigeonEntity baby = (PigeonEntity)((EntityType)ReAnimalEntities.PIGEON.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, this::mainPredicate));
    }

    public boolean isScaredBy(LivingEntity entity) {
        if (!this.getBoundingBox().inflate(7.0, 3.0, 7.0).intersects(entity.getBoundingBox())) {
            return false;
        }
        if (entity.getType().is(EntityTypeTags.UNDEAD)) {
            return true;
        }
        if (this.getLastHurtByMob() == entity) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isSpectator() && (player.isSprinting() || player.isPassenger());
        }
        return false;
    }

    private PlayState mainPredicate(AnimationState<PigeonEntity> state) {
        AnimationController controller = state.getController();
        PigeonEntity entity = (PigeonEntity)state.getAnimatable();
        if (state.isMoving()) {
            if (entity.onGround()) {
                controller.setAnimation(WALK);
            } else {
                controller.setAnimation(FLY);
            }
        } else if (entity.isPecking()) {
            controller.setAnimation(PECK);
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.STEP_HEIGHT, 1.1);
    }

    private void tickEggLaying() {
        if (this.level().isClientSide() || this.isBaby()) {
            return;
        }
        if (--this.eggTime > 0) {
            return;
        }
        this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.spawnAtLocation((ItemLike)ReAnimalItems.PIGEON_EGG.get());
        this.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)this);
        this.eggTime = this.random.nextInt(6000) + 6000;
    }
}

