/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.hippopotamus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.hippopotamus.HippopotamusEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSensorTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class HippopotamusAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super HippopotamusEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)ReAnimalSensorTypes.HIPPOPOTAMUS_TEMPTATIONS.get()), (Object)SensorType.NEAREST_ADULT, (Object)SensorType.NEAREST_PLAYERS);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_VISIBLE_PLAYER});
    public static final int ATTACK_ANIMATION_TICKS = 12;
    private static final int ATTACK_HIT_TICK = 11;
    private static final int ATTACK_COOLDOWN_TICKS = 20;

    public static Brain.Provider<HippopotamusEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<HippopotamusEntity> brain) {
        HippopotamusAI.initCoreActivity(brain);
        HippopotamusAI.initIdleActivity(brain);
        HippopotamusAI.initPanicActivity(brain);
        HippopotamusAI.initFightActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<HippopotamusEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new LayCooldownBehavior()), (Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<HippopotamusEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create(HippopotamusAI::findNearestAttackableEntity)), (Object)Pair.of((Object)1, (Object)((Object)new LayBehavior())), (Object)Pair.of((Object)2, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new AnimalMakeLove((EntityType)ReAnimalEntities.HIPPOPOTAMUS.get(), 1.0f, 1)), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)4, (int)8), (float)1.25f), (Object)1)))), (Object)Pair.of((Object)5, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)6, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initFightActivity(Brain<HippopotamusEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)((Object)new HippopotamusAttack(12, 11, 20)), (Object)StopAttackingIfTargetInvalid.create()), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initPanicActivity(Brain<HippopotamusEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.PANIC, 10, ImmutableList.of((Object)new AnimalPanic(2.5f, mob -> DamageTypeTags.PANIC_CAUSES)), MemoryModuleType.IS_PANICKING);
    }

    public static void updateActivity(HippopotamusEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(ReAnimalTags.Items.HIPPOPOTAMUS_FOOD);
    }

    private static Optional<LivingEntity> getAttackTarget(HippopotamusEntity entity) {
        return entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
    }

    private static Optional<? extends LivingEntity> findNearestAttackableEntity(HippopotamusEntity entity) {
        Brain brain = entity.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) || brain.hasMemoryValue(MemoryModuleType.IS_TEMPTED) || !brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)) {
            return Optional.empty();
        }
        double followRange = entity.getAttributeValue(Attributes.FOLLOW_RANGE);
        double maxDistanceSq = followRange * followRange;
        Optional<Player> playerTarget = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).filter(target -> HippopotamusAI.isValidTarget(entity, (LivingEntity)target) && target.distanceToSqr((Entity)entity) <= maxDistanceSq);
        if (playerTarget.isPresent()) {
            return playerTarget;
        }
        return brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty()).findClosest(target -> HippopotamusAI.isValidTarget(entity, target) && target.distanceToSqr((Entity)entity) <= maxDistanceSq);
    }

    public static boolean isValidTarget(HippopotamusEntity self, LivingEntity target) {
        return target.getType() != ReAnimalEntities.HIPPOPOTAMUS.get() && !(target instanceof Monster) && Sensor.isEntityAttackable((LivingEntity)self, (LivingEntity)target) && !HippopotamusAI.isHoldingFavoriteFood(target);
    }

    public static boolean isHoldingFavoriteFood(LivingEntity target) {
        return target.getMainHandItem().is(ReAnimalTags.Items.HIPPOPOTAMUS_FOOD) || target.getOffhandItem().is(ReAnimalTags.Items.HIPPOPOTAMUS_FOOD);
    }

    public static class LayCooldownBehavior
    extends Behavior<HippopotamusEntity> {
        public LayCooldownBehavior() {
            super((Map)ImmutableMap.of(), 1200);
        }

        protected boolean canStillUse(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            return true;
        }

        protected void tick(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            if (entity.layCooldown > 0) {
                --entity.layCooldown;
            }
        }
    }

    public static class LayBehavior
    extends Behavior<HippopotamusEntity> {
        public LayBehavior() {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 1200);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, HippopotamusEntity entity) {
            return entity.layCooldown == 0 && entity.canStartLaying();
        }

        protected void start(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            entity.startLayingDown();
        }

        protected boolean canStillUse(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            return entity.getLayState() != HippopotamusEntity.LayState.STANDING;
        }

        protected void tick(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            boolean shouldAbort;
            Brain brain = entity.getBrain();
            HippopotamusEntity.LayState layState = entity.getLayState();
            boolean bl = shouldAbort = brain.hasMemoryValue(MemoryModuleType.IS_PANICKING) || brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET) || brain.hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER) || entity.isInWaterOrBubble();
            if ((layState == HippopotamusEntity.LayState.LAYING_DOWN || layState == HippopotamusEntity.LayState.LAYING) && shouldAbort) {
                entity.startGettingUp();
                layState = entity.getLayState();
            }
            switch (layState) {
                case LAYING_DOWN: {
                    if (--entity.layTime > 0) break;
                    entity.layTime = HippopotamusEntity.LAY_DURATION.sample(entity.getRandom());
                    entity.setLayState(HippopotamusEntity.LayState.LAYING);
                    break;
                }
                case LAYING: {
                    entity.getNavigation().stop();
                    if (--entity.layTime > 0) break;
                    entity.startGettingUp();
                    break;
                }
                case GETTING_UP: {
                    if (--entity.layTime > 0) break;
                    entity.finishGettingUp();
                    break;
                }
            }
        }

        protected void stop(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            if (entity.getLayState() != HippopotamusEntity.LayState.STANDING) {
                entity.finishGettingUp();
            }
        }
    }

    private static class HippopotamusAttack
    extends Behavior<HippopotamusEntity> {
        private final int animationLength;
        private final int hitTick;
        private final int cooldownTicks;
        private int elapsedTicks;
        private boolean dealtDamage;

        public HippopotamusAttack(int animationLength, int hitTick, int cooldownTicks) {
            super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.REGISTERED));
            this.animationLength = animationLength;
            this.hitTick = hitTick;
            this.cooldownTicks = cooldownTicks;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean checkExtraStartConditions(ServerLevel level, HippopotamusEntity entity) {
            if (entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_COOLING_DOWN)) return false;
            if (!HippopotamusAI.getAttackTarget(entity).filter(arg_0 -> ((HippopotamusEntity)entity).isWithinMeleeAttackRange(arg_0)).isPresent()) return false;
            return true;
        }

        protected void start(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            this.elapsedTicks = 0;
            this.dealtDamage = false;
            entity.startAttackAnimation();
        }

        protected boolean canStillUse(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            return this.elapsedTicks < this.animationLength && HippopotamusAI.getAttackTarget(entity).filter(LivingEntity::isAlive).isPresent();
        }

        protected void tick(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            ++this.elapsedTicks;
            HippopotamusAI.getAttackTarget(entity).ifPresent(target -> {
                entity.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                if (!this.dealtDamage && this.elapsedTicks == this.hitTick && entity.isWithinMeleeAttackRange((LivingEntity)target)) {
                    this.dealtDamage = entity.doHurtTarget((Entity)target);
                }
            });
        }

        protected void stop(ServerLevel level, HippopotamusEntity entity, long gameTime) {
            entity.setAttacking(false);
            entity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)Boolean.TRUE, (long)this.cooldownTicks);
        }
    }
}

