/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.hedgehog;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import it.hurts.shatterbyte.reanimal.common.entity.hedgehog.HedgehogAI;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntityDataSerializers;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import java.util.function.IntFunction;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HedgehogEntity
extends Animal
implements GeoEntity {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.hedgehog.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.hedgehog.walk");
    private static final RawAnimation ROLL = RawAnimation.begin().then("animation.hedgehog.roll", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation UNROLL = RawAnimation.begin().then("animation.hedgehog.unroll", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SCARED = RawAnimation.begin().thenLoop("animation.hedgehog.scared");
    private static final EntityDataAccessor<HedgehogState> STATE = SynchedEntityData.defineId(HedgehogEntity.class, ReAnimalEntityDataSerializers.HEDGEHOG_STATE.get());
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public long inStateTicks = 0L;

    public HedgehogState getState() {
        return (HedgehogState)((Object)this.getEntityData().get(STATE));
    }

    public void setState(HedgehogState state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(STACK);
    }

    public void setStack(ItemStack stack) {
        this.getEntityData().set(STACK, (Object)stack);
    }

    public boolean isScared() {
        return this.entityData.get(STATE) != HedgehogState.IDLE;
    }

    public HedgehogEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level level = this.level();
        ItemStack back = this.getStack();
        ItemStack held = player.getItemInHand(hand);
        if (!back.isEmpty()) {
            if (!level.isClientSide()) {
                ItemStack toGive = back.copy();
                this.setStack(ItemStack.EMPTY);
                if (!player.addItem(toGive)) {
                    this.spawnAtLocation(toGive);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!held.isEmpty()) {
            InteractionResult result;
            if (this.isFood(held) && (result = super.mobInteract(player, hand)).consumesAction()) {
                return result;
            }
            if (!level.isClientSide()) {
                this.setStack(held.copy());
                if (!player.getAbilities().instabuild) {
                    held.shrink(held.getCount());
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        ++this.inStateTicks;
        if (!this.isBaby()) {
            List targets = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), candidate -> !(candidate instanceof HedgehogEntity));
            boolean damagedSomeone = false;
            for (LivingEntity target : targets) {
                boolean damaged = target.hurt(level.damageSources().thorns((Entity)this), this.getState() == HedgehogState.SCARED ? 5.0f : 1.0f);
                damagedSomeone = damagedSomeone || damaged;
            }
            if (damagedSomeone) {
                this.getBrain().setMemoryWithExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY, (Object)true, 80L);
            }
        }
    }

    protected void customServerAiStep() {
        Level level = this.level();
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("hedgehogBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("hedgehogActivityUpdate");
        HedgehogAI.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity entity;
        Entity attacker;
        boolean result = super.hurt(source, amount);
        if (result && !this.level().isClientSide() && (attacker = source.getEntity()) instanceof LivingEntity && (entity = (LivingEntity)attacker).getMainHandItem().isEmpty()) {
            entity.hurt(this.damageSources().thorns((Entity)this), 1.0f);
        }
        return result;
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl((Mob)this){

            public void clientTick() {
                if (HedgehogEntity.this.isScared()) {
                    return;
                }
                super.clientTick();
            }
        };
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, source, recentlyHit);
        ItemStack stack = this.getStack();
        if (!stack.isEmpty()) {
            this.spawnAtLocation(stack);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("state", this.getState().getName());
        ItemStack stack = this.getStack();
        if (!stack.isEmpty()) {
            tag.put("stack", stack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setState(HedgehogState.fromName(tag.getString("state")));
        if (tag.contains("stack")) {
            this.setStack(ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)tag.getCompound("stack")).orElse(ItemStack.EMPTY));
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (STATE.equals(data)) {
            this.inStateTicks = 0L;
        }
        super.onSyncedDataUpdated(data);
    }

    protected Brain.Provider<HedgehogEntity> brainProvider() {
        return HedgehogAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return HedgehogAI.makeBrain((Brain<HedgehogEntity>)this.brainProvider().makeBrain(dynamic));
    }

    protected void defineSynchedData(SynchedEntityData.Builder buidler) {
        super.defineSynchedData(buidler);
        buidler.define(STATE, (Object)HedgehogState.IDLE);
        buidler.define(STACK, (Object)ItemStack.EMPTY);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ReAnimalTags.Items.HEDGEHOG_FOOD);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        HedgehogEntity baby = (HedgehogEntity)((EntityType)ReAnimalEntities.HEDGEHOG.get()).create((Level)level);
        if (baby != null) {
            baby.setBaby(true);
        }
        return baby;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 0, this::mainPredicate));
    }

    private PlayState mainPredicate(AnimationState<HedgehogEntity> state) {
        AnimationController controller = state.getController();
        HedgehogState hedgehogState = this.getState();
        if (hedgehogState != HedgehogState.IDLE) {
            switch (hedgehogState.ordinal()) {
                case 1: {
                    controller.setAnimation(ROLL);
                    break;
                }
                case 2: {
                    controller.setAnimation(SCARED);
                    break;
                }
                case 3: {
                    controller.setAnimation(UNROLL);
                }
            }
            return PlayState.CONTINUE;
        }
        if (state.isMoving()) {
            controller.setAnimation(WALK);
        } else {
            controller.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 8.0);
    }

    public boolean canStayRolledUp() {
        return !this.isPanicking() && !this.isInLiquid() && !this.isLeashed() && !this.isPassenger() && !this.isVehicle();
    }

    public boolean isScaredBy(LivingEntity entity) {
        if (!this.getBoundingBox().inflate(5.0, 2.0, 5.0).intersects(entity.getBoundingBox())) {
            return false;
        }
        if (entity.getType().is(EntityTypeTags.UNDEAD)) {
            return true;
        }
        if (this.getLastHurtByMob() == entity) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.isSpectator() && (player.isSprinting() || player.isPassenger());
        }
        return false;
    }

    public void rollUp() {
        if (this.isScared()) {
            return;
        }
        this.stopInPlace();
        this.resetLove();
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEvents.ARMADILLO_ROLL);
        this.setState(HedgehogState.ROLLING);
    }

    public void rollOut() {
        if (!this.isScared()) {
            return;
        }
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.setState(HedgehogState.IDLE);
    }

    public static enum HedgehogState implements StringRepresentable
    {
        IDLE("idle", false, 0, 0),
        ROLLING("rolling", true, 23, 1),
        SCARED("scared", true, 50, 2),
        UNROLLING("unrolling", true, 23, 3);

        private static final IntFunction<HedgehogState> BY_ID;
        private static final StringRepresentable.EnumCodec<HedgehogState> CODEC;
        public static final StreamCodec<ByteBuf, HedgehogState> STREAM_CODEC;
        private final String name;
        private final boolean isThreatened;
        private final int animationDuration;
        private final int id;

        public static HedgehogState fromName(String name) {
            return (HedgehogState)CODEC.byName(name, (Enum)IDLE);
        }

        public String getSerializedName() {
            return this.name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean isThreatened() {
            return this.isThreatened;
        }

        @Generated
        public int getAnimationDuration() {
            return this.animationDuration;
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        private HedgehogState(String name, boolean isThreatened, int animationDuration, int id) {
            this.name = name;
            this.isThreatened = isThreatened;
            this.animationDuration = animationDuration;
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(HedgehogState::getId, (Object[])HedgehogState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(HedgehogState::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, HedgehogState::getId);
        }
    }
}

