/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.hedgehog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.reanimal.common.entity.hedgehog.HedgehogEntity;
import it.hurts.shatterbyte.reanimal.init.ReAnimalEntities;
import it.hurts.shatterbyte.reanimal.init.ReAnimalSensorTypes;
import it.hurts.shatterbyte.reanimal.init.ReAnimalTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class HedgehogAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super HedgehogEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)ReAnimalSensorTypes.HEDGEHOG_TEMPTATIONS.get()), (Object)SensorType.NEAREST_ADULT, (Object)((SensorType)ReAnimalSensorTypes.HEDGEHOG_SCARE_DETECTED.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.GAZE_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.DANGER_DETECTED_RECENTLY});
    private static final OneShot<HedgehogEntity> HEDGEHOG_ROLLING_OUT = BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.DANGER_DETECTED_RECENTLY)).apply((Applicative)instance, accessor -> (level, entity, id) -> {
        if (entity.isScared()) {
            entity.rollOut();
            return true;
        }
        return false;
    }));

    public static Brain.Provider<HedgehogEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<HedgehogEntity> brain) {
        HedgehogAI.initCoreActivity(brain);
        HedgehogAI.initIdleActivity(brain);
        HedgehogAI.initScaredActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<HedgehogEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)((Object)new HedgehogPanic(2.0f)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(){

            protected boolean checkExtraStartConditions(ServerLevel level, Mob mob) {
                HedgehogEntity hedgehog;
                if (mob instanceof HedgehogEntity && (hedgehog = (HedgehogEntity)mob).isScared()) {
                    return false;
                }
                return super.checkExtraStartConditions(level, mob);
            }
        }, (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS), HEDGEHOG_ROLLING_OUT));
    }

    private static void initIdleActivity(Brain<HedgehogEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove((EntityType)ReAnimalEntities.HEDGEHOG.get(), 1.0f, 1)), (Object)Pair.of((Object)2, (Object)((Object)new HedgehogPickupItem())), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(entity -> Float.valueOf(1.25f), entity -> entity.isBaby() ? 1.0 : 2.0), (Object)1), (Object)Pair.of((Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)2, (int)5), (float)1.25f), (Object)1)))), (Object)Pair.of((Object)4, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initScaredActivity(Brain<HedgehogEntity> brain) {
        brain.addActivityWithConditions(Activity.PANIC, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new HedgehogBallUp()))), Set.of(Pair.of((Object)MemoryModuleType.DANGER_DETECTED_RECENTLY, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(HedgehogEntity entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.PANIC, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return stack -> stack.is(ReAnimalTags.Items.HEDGEHOG_FOOD);
    }

    public static class HedgehogPanic
    extends AnimalPanic<HedgehogEntity> {
        public HedgehogPanic(float speedMultiplier) {
            super(speedMultiplier, mob -> DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES);
        }

        protected void start(ServerLevel level, HedgehogEntity entity, long id) {
            entity.rollOut();
            super.start(level, (PathfinderMob)entity, id);
        }
    }

    public static class HedgehogPickupItem
    extends Behavior<HedgehogEntity> {
        private static final int SEARCH_RADIUS = 8;
        private static final int MAX_DURATION = 200;

        public HedgehogPickupItem() {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED), 200);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, HedgehogEntity entity) {
            if (entity.isBaby()) {
                return false;
            }
            if (!entity.getStack().isEmpty()) {
                return false;
            }
            ItemEntity nearest = this.findNearestItem(level, entity);
            if (nearest == null) {
                return false;
            }
            entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)nearest, false), 1.1f, 0));
            return true;
        }

        protected boolean canStillUse(ServerLevel level, HedgehogEntity entity, long gameTime) {
            EntityTracker entityTracker;
            Entity target;
            if (entity.isBaby() || !entity.getStack().isEmpty()) {
                return false;
            }
            Optional opt = entity.getBrain().getMemory(MemoryModuleType.WALK_TARGET);
            if (opt.isEmpty()) {
                return false;
            }
            PositionTracker tracker = ((WalkTarget)opt.get()).getTarget();
            if (!(!(tracker instanceof EntityTracker) || (target = (entityTracker = (EntityTracker)tracker).getEntity()).isAlive() && target instanceof ItemEntity)) {
                entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                return false;
            }
            return true;
        }

        protected void tick(ServerLevel level, HedgehogEntity entity, long gameTime) {
            super.tick(level, (LivingEntity)entity, gameTime);
            Optional opt = entity.getBrain().getMemory(MemoryModuleType.WALK_TARGET);
            if (opt.isEmpty()) {
                return;
            }
            PositionTracker tracker = ((WalkTarget)opt.get()).getTarget();
            if (!(tracker instanceof EntityTracker)) {
                return;
            }
            EntityTracker entityTracker = (EntityTracker)tracker;
            Entity target = entityTracker.getEntity();
            if (!target.isAlive() || !(target instanceof ItemEntity)) {
                return;
            }
            ItemEntity item = (ItemEntity)target;
            if (entity.position().distanceTo(item.position()) <= 1.5) {
                if (entity.getStack().isEmpty()) {
                    entity.setStack(item.getItem().copy());
                    item.discard();
                }
                entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            }
        }

        protected void stop(ServerLevel level, HedgehogEntity entity, long gameTime) {
            entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        }

        private ItemEntity findNearestItem(ServerLevel level, HedgehogEntity entity) {
            List list = level.getEntitiesOfClass(ItemEntity.class, entity.getBoundingBox().inflate(8.0), item -> item.isAlive() && !item.getItem().isEmpty());
            if (list.isEmpty()) {
                return null;
            }
            ItemEntity nearest = (ItemEntity)list.getFirst();
            double bestDist = entity.distanceToSqr((Entity)nearest);
            for (ItemEntity other : list) {
                double d = entity.distanceToSqr((Entity)other);
                if (!(d < bestDist)) continue;
                bestDist = d;
                nearest = other;
            }
            return nearest;
        }
    }

    public static class HedgehogBallUp
    extends Behavior<HedgehogEntity> {
        static final int BALL_UP_STAY_IN_STATE = 5 * TimeUtil.SECONDS_PER_MINUTE * 20;
        int nextPeekTimer = 0;
        boolean dangerWasAround;

        public HedgehogBallUp() {
            super(Map.of(), BALL_UP_STAY_IN_STATE);
        }

        protected void tick(ServerLevel level, HedgehogEntity entity, long id) {
            super.tick(level, (LivingEntity)entity, id);
            if (this.nextPeekTimer > 0) {
                --this.nextPeekTimer;
            }
            if (entity.getState() == HedgehogEntity.HedgehogState.ROLLING && entity.inStateTicks > (long)HedgehogEntity.HedgehogState.ROLLING.getAnimationDuration()) {
                entity.setState(HedgehogEntity.HedgehogState.SCARED);
            } else {
                boolean flag;
                HedgehogEntity.HedgehogState state = entity.getState();
                long i = entity.getBrain().getTimeUntilExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY);
                boolean bl = flag = i > 75L;
                if (flag != this.dangerWasAround) {
                    this.nextPeekTimer = this.pickNextPeekTimer(entity);
                }
                this.dangerWasAround = flag;
                if (state == HedgehogEntity.HedgehogState.SCARED) {
                    if (this.nextPeekTimer == 0 && entity.onGround() && flag) {
                        level.broadcastEntityEvent((Entity)entity, (byte)64);
                        this.nextPeekTimer = this.pickNextPeekTimer(entity);
                    }
                    if (i < (long)HedgehogEntity.HedgehogState.UNROLLING.getAnimationDuration()) {
                        entity.setState(HedgehogEntity.HedgehogState.UNROLLING);
                    }
                } else if (state == HedgehogEntity.HedgehogState.UNROLLING && i > (long)HedgehogEntity.HedgehogState.UNROLLING.getAnimationDuration()) {
                    entity.setState(HedgehogEntity.HedgehogState.SCARED);
                }
            }
        }

        private int pickNextPeekTimer(HedgehogEntity entity) {
            return HedgehogEntity.HedgehogState.SCARED.getAnimationDuration() + entity.getRandom().nextIntBetweenInclusive(100, 400);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, HedgehogEntity entity) {
            return entity.onGround();
        }

        protected boolean canStillUse(ServerLevel level, HedgehogEntity entity, long id) {
            return entity.getState().isThreatened();
        }

        protected void start(ServerLevel level, HedgehogEntity entity, long id) {
            entity.rollUp();
        }

        protected void stop(ServerLevel level, HedgehogEntity entity, long id) {
            if (!entity.canStayRolledUp()) {
                entity.rollOut();
            }
        }
    }
}

