/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.entity.egg;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class ThrowableEggEntity
extends ThrowableItemProjectile {
    protected ThrowableEggEntity(EntityType<? extends ThrowableEggEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected Item getDefaultItem() {
        return this.getEggItem();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (!level.isClientSide()) {
            this.tryHatch((ServerLevel)level);
            level.broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    private void tryHatch(ServerLevel level) {
        if (this.random.nextInt(8) != 0) {
            return;
        }
        int hatchlingCount = this.random.nextInt(32) == 0 ? 4 : 1;
        EntityType<? extends AgeableMob> hatchlingType = this.getHatchlingType();
        for (int i = 0; i < hatchlingCount; ++i) {
            AgeableMob hatchling = (AgeableMob)hatchlingType.create((Level)level);
            if (hatchling == null) continue;
            hatchling.setBaby(true);
            hatchling.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            level.addFreshEntity((Entity)hatchling);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.ITEM, this.getItem());
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particle, this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    protected abstract Item getEggItem();

    protected abstract EntityType<? extends AgeableMob> getHatchlingType();
}

