/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.common.block;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class QuillPlatformBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<QuillPlatformBlock> CODEC = BlockBehaviour.simpleCodec(QuillPlatformBlock::new);
    private static final VoxelShape FLOOR_SHAPE = FaceAttachedHorizontalDirectionalBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape CEILING_SHAPE = FaceAttachedHorizontalDirectionalBlock.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = FaceAttachedHorizontalDirectionalBlock.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = FaceAttachedHorizontalDirectionalBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
    private static final VoxelShape WEST_SHAPE = FaceAttachedHorizontalDirectionalBlock.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = FaceAttachedHorizontalDirectionalBlock.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0);
    private static final GameProfile QUILL_FAKE_PROFILE = new GameProfile(UUID.fromString("3f6b43f9-bf91-4d81-a152-9b2d7a23f4b7"), "ReAnimal_QuillPlatform");

    public QuillPlatformBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<QuillPlatformBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACE});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction support = FaceAttachedHorizontalDirectionalBlock.getConnectedDirection((BlockState)state).getOpposite();
        return FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)level, (BlockPos)pos, (Direction)support);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return FaceAttachedHorizontalDirectionalBlock.getConnectedDirection((BlockState)state).getOpposite() == direction && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighbor, level, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getPlatformShape(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    private VoxelShape getPlatformShape(BlockState state) {
        AttachFace face = (AttachFace)state.getValue((Property)FACE);
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> FLOOR_SHAPE;
            case AttachFace.CEILING -> CEILING_SHAPE;
            case AttachFace.WALL -> {
                switch (direction) {
                    case NORTH: {
                        yield NORTH_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_SHAPE;
                    }
                    case WEST: {
                        yield WEST_SHAPE;
                    }
                    case EAST: {
                        yield EAST_SHAPE;
                    }
                }
                yield FLOOR_SHAPE;
            }
        };
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        VoxelShape shape = this.getPlatformShape(state).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        AABB entityBox = entity.getBoundingBox();
        boolean intersects = false;
        for (AABB box : shape.toAabbs()) {
            if (!box.intersects(entityBox)) continue;
            intersects = true;
            break;
        }
        if (!intersects) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.makeStuckInBlock(state, new Vec3(0.75, 1.0, 0.75));
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)QUILL_FAKE_PROFILE);
            fakePlayer.setPos(Vec3.atCenterOf((Vec3i)pos));
            Vec3 motion = living.getDeltaMovement();
            if (living.hurt(serverLevel.damageSources().playerAttack((Player)fakePlayer), 1.0f)) {
                living.setDeltaMovement(motion);
                living.setLastHurtByMob(null);
            }
        }
    }
}

