/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.renderer.hedgehog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.hurts.shatterbyte.reanimal.common.entity.hedgehog.HedgehogEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class HedgehogItemLayer
extends GeoRenderLayer<HedgehogEntity> {
    public HedgehogItemLayer(GeoRenderer<HedgehogEntity> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, HedgehogEntity animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.isDeadOrDying()) {
            return;
        }
        ItemStack stack = animatable.getStack();
        if (stack.isEmpty()) {
            return;
        }
        GeoBone bone = bakedModel.getBone("item").orElse(null);
        if (bone == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.525f, 0.0f);
        Vector3d modelPos = bone.getModelPosition();
        poseStack.translate(modelPos.x / 16.0, modelPos.y / 16.0, modelPos.z / 16.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-Mth.rotLerp((float)partialTick, (float)animatable.yBodyRotO, (float)animatable.yBodyRot)));
        poseStack.mulPose(bone.getModelRotationMatrix());
        poseStack.scale(0.5f, 0.5f, 0.5f);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, animatable.level(), animatable.getId());
        poseStack.popPose();
    }
}

