/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.reanimal.client.model.penguin;

import it.hurts.shatterbyte.reanimal.common.entity.penguin.PenguinEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class PenguinModel
extends GeoModel<PenguinEntity> {
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"geo/penguin.geo.json");
    private static final ResourceLocation TEXTURE_ADULT = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/penguin_adult.png");
    private static final ResourceLocation TEXTURE_BABY = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"textures/entity/penguin_baby.png");
    private static final ResourceLocation ANIMATION = ResourceLocation.fromNamespaceAndPath((String)"reanimal", (String)"animations/penguin.animation.json");

    public ResourceLocation getModelResource(PenguinEntity entity) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(PenguinEntity entity) {
        return entity.isBaby() ? TEXTURE_BABY : TEXTURE_ADULT;
    }

    public ResourceLocation getAnimationResource(PenguinEntity entity) {
        return ANIMATION;
    }

    public void setCustomAnimations(PenguinEntity animatable, long instanceId, AnimationState<PenguinEntity> state) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, state);
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head == null) {
            return;
        }
        EntityModelData modelData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
        float headYaw = modelData.netHeadYaw() * ((float)Math.PI / 180);
        float headPitch = modelData.headPitch() * ((float)Math.PI / 180);
        head.setRotY(headYaw);
        head.setRotX(headPitch);
    }
}

