/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.data.client;

import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.util.ResourceUtil;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(PackOutput packOutput, ExistingFileHelper fileHelper) {
        super(packOutput, "pylons", fileHelper);
    }

    protected void registerStatesAndModels() {
        this.pylon(ModRegistry.EXPULSION_PYLON, "diamond_block");
        this.pylon(ModRegistry.INFUSION_PYLON, "emerald_block");
        this.pylon(ModRegistry.HARVESTER_PYLON, "hay_block_side");
        this.pylon(ModRegistry.INTERDICTION_PYLON, "netherite_block");
        this.pylon(ModRegistry.PROTECTION_PYLON, "honeycomb_block");
    }

    protected void pylon(DeferredBlock<Block> block, String texture) {
        ResourceLocation key = block.getKey().location();
        String blockName = Objects.requireNonNull(key).toString();
        ModelBuilder pylonModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName, ResourceUtil.prefix("block/pylon"))).texture("particle", ResourceLocation.withDefaultNamespace((String)"block/".concat(texture)))).texture("center", ResourceLocation.withDefaultNamespace((String)"block/".concat(texture)));
        this.simpleBlock((Block)block.get(), (ModelFile)pylonModel);
        this.simpleBlockItem((Block)block.get(), (ModelFile)pylonModel);
    }
}

