/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.Block;
import net.permutated.pylons.recipe.HarvestingRecipe;

public class HarvestingRegistry {
    private final Object lock = new Object();
    private List<HarvestingRecipe> recipeList = new ArrayList<HarvestingRecipe>();
    private final Map<Block, Optional<HarvestingRecipe>> recipeByBlockCache = new ConcurrentHashMap<Block, Optional<HarvestingRecipe>>();

    public Optional<HarvestingRecipe> findRecipe(Block block) {
        return this.recipeByBlockCache.computeIfAbsent(block, b -> this.recipeList.stream().filter(recipe -> recipe.getInput().equals(b)).findFirst());
    }

    public boolean hasRecipe(Block block) {
        return this.findRecipe(block).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecipeList(List<HarvestingRecipe> recipes) {
        Object object = this.lock;
        synchronized (object) {
            this.recipeList = List.copyOf(recipes);
            this.recipeByBlockCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HarvestingRecipe> getRecipeList() {
        Object object = this.lock;
        synchronized (object) {
            return this.recipeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecipes() {
        Object object = this.lock;
        synchronized (object) {
            this.recipeList = Collections.emptyList();
            this.recipeByBlockCache.clear();
        }
    }
}

