/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.interdiction;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.components.EntityComponent;
import net.permutated.pylons.item.LifelessFilterCard;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.SpawnManager;

public class InterdictionPylonTile
extends AbstractPylonTile {
    private boolean dirty = true;

    public InterdictionPylonTile(BlockPos pos, BlockState state) {
        super(ModRegistry.INTERDICTION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{1, 3, 5};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.getItem() instanceof MobFilterCard || stack.getItem() instanceof LifelessFilterCard;
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(20) && this.dirty) {
                HashSet<ResourceLocation> filters = new HashSet<ResourceLocation>();
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (!stack.isEmpty() && stack.getItem() instanceof MobFilterCard) {
                        EntityComponent data = (EntityComponent)stack.get(ModRegistry.ENTITY_COMPONENT);
                        if (data == null) continue;
                        filters.add(data.registryKey());
                        continue;
                    }
                    if (stack.isEmpty() || !(stack.getItem() instanceof LifelessFilterCard)) continue;
                    SpawnManager.registerLifeless(serverLevel, this.worldPosition);
                    this.dirty = false;
                    return;
                }
                SpawnManager.register(serverLevel, this.worldPosition, this.range, filters);
                this.dirty = false;
            }
        }
    }

    @Override
    public boolean shouldWork() {
        if (super.shouldWork()) {
            return true;
        }
        this.removeChunkloads();
        return false;
    }

    @Override
    public void removeChunkloads() {
        super.removeChunkloads();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SpawnManager.unregister(serverLevel, this.worldPosition);
            this.dirty = true;
        }
    }

    public void setChanged() {
        super.setChanged();
        this.dirty = true;
    }
}

