/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.components.PotionComponent;
import net.permutated.pylons.util.TranslationKey;

public class PotionFilterCard
extends Item {
    public PotionFilterCard() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    public static int getMinimumDuration() {
        return (Integer)ConfigManager.SERVER.infusionMinimumDuration.get() * 20;
    }

    public static int getRequiredDuration() {
        return (Integer)ConfigManager.SERVER.infusionRequiredDuration.get() * 20;
    }

    public static int getAppliedDuration() {
        return (Integer)ConfigManager.SERVER.infusionAppliedDuration.get() * 20;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof PotionFilterCard) {
            if (!level.isClientSide) {
                PotionComponent offhandData;
                ItemStack offhand;
                PotionComponent data = (PotionComponent)stack.get(ModRegistry.POTION_COMPONENT);
                if (data != null && data.duration() >= PotionFilterCard.getRequiredDuration()) {
                    return InteractionResultHolder.success((Object)stack);
                }
                if (hand == InteractionHand.MAIN_HAND && data != null && (offhand = player.getItemInHand(InteractionHand.OFF_HAND)).getItem() instanceof PotionFilterCard && (offhandData = (PotionComponent)offhand.get(ModRegistry.POTION_COMPONENT)) != null && data.matches(offhandData)) {
                    ItemStack copy = PotionFilterCard.addDuration(stack, offhandData.duration());
                    player.setItemInHand(InteractionHand.OFF_HAND, PotionFilterCard.clearEffect(offhand));
                    return InteractionResultHolder.success((Object)copy);
                }
                Optional<MobEffectInstance> active = data == null ? player.getActiveEffects().stream().filter(effectInstance -> effectInstance.getDuration() >= PotionFilterCard.getMinimumDuration()).findFirst() : player.getActiveEffects().stream().filter(effectInstance -> effectInstance.getDuration() >= PotionFilterCard.getMinimumDuration()).filter(effectInstance -> effectInstance.getEffect().is(data.effect())).filter(effectInstance -> Objects.equals(effectInstance.getAmplifier(), data.amplifier())).findFirst();
                if (active.isPresent()) {
                    Holder activeEffect = active.get().getEffect();
                    int activeAmplifier = active.get().getAmplifier();
                    int activeDuration = active.get().getDuration();
                    ItemStack copy = data == null ? PotionFilterCard.withEffect(stack, (Holder<MobEffect>)activeEffect, activeAmplifier, activeDuration) : PotionFilterCard.addDuration(stack, activeDuration);
                    player.removeEffect(activeEffect);
                    return InteractionResultHolder.success((Object)copy);
                }
            } else {
                return InteractionResultHolder.consume((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.getComponents().has(ModRegistry.POTION_COMPONENT.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        PotionComponent data = (PotionComponent)stack.get(ModRegistry.POTION_COMPONENT);
        if (data != null) {
            MobEffect effect = (MobEffect)data.effect().value();
            int duration = data.duration();
            int amplifier = data.amplifier();
            int display = duration < 20 ? 0 : duration / 20;
            MutableComponent component = effect.getDisplayName().copy();
            if (amplifier > 0) {
                component = this.withAmplifier(component, amplifier);
            }
            if (effect.isBeneficial()) {
                tooltip.add((Component)component.withStyle(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)component.withStyle(ChatFormatting.RED));
            }
            if (!PotionFilterCard.isAllowed(stack)) {
                tooltip.add((Component)this.translate("effect_denied").withStyle(ChatFormatting.RED));
            }
            if (PotionFilterCard.limitedPotency(stack)) {
                String potencyKey = String.format("potion.potency.%d", ConfigManager.SERVER.infusionMaximumPotency.getAsInt());
                tooltip.add((Component)this.translate("potency_capped", Component.translatable((String)potencyKey)).withStyle(ChatFormatting.YELLOW));
            }
            tooltip.add((Component)Component.empty());
            if (duration >= PotionFilterCard.getRequiredDuration()) {
                tooltip.add((Component)this.translate("insert1"));
                tooltip.add((Component)this.translate("insert2"));
                tooltip.add((Component)this.translate("activated").withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)this.translate("increase1"));
                tooltip.add((Component)this.translate("increase2"));
                tooltip.add((Component)this.translate("progress", display, PotionFilterCard.getRequiredDuration() / 20).withStyle(ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)this.translate("no_effect1"));
            tooltip.add((Component)this.translate("no_effect2"));
            tooltip.add((Component)this.translate("minimum_duration", PotionFilterCard.getMinimumDuration() / 20));
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)this.translate("infusion"));
    }

    public static ItemStack withEffect(ItemStack stack, Holder<MobEffect> effect, int amplifier, int duration) {
        ItemStack copy = stack.copy();
        copy.set(ModRegistry.POTION_COMPONENT, (Object)new PotionComponent(effect, amplifier, duration));
        return copy;
    }

    public static ItemStack addDuration(ItemStack stack, int duration) {
        ItemStack copy = stack.copy();
        PotionComponent data = (PotionComponent)copy.get(ModRegistry.POTION_COMPONENT);
        if (data != null && data.duration() < PotionFilterCard.getRequiredDuration()) {
            int current = data.duration();
            int total = Math.min(PotionFilterCard.getRequiredDuration(), current + duration);
            copy.set(ModRegistry.POTION_COMPONENT, (Object)new PotionComponent(data.effect(), data.amplifier(), total));
        }
        return copy;
    }

    public static ItemStack clearEffect(ItemStack stack) {
        ItemStack copy = stack.copy();
        copy.remove(ModRegistry.POTION_COMPONENT);
        return copy;
    }

    public static boolean isAllowed(ItemStack stack) {
        return Optional.ofNullable((PotionComponent)stack.get(ModRegistry.POTION_COMPONENT)).map(PotionComponent::effect).flatMap(Holder::unwrapKey).map(ResourceKey::location).map(location -> PotionFilterCard.isAllowedEffect(location) && !PotionFilterCard.isDeniedEffect(location)).orElse(false);
    }

    public static boolean limitedPotency(ItemStack stack) {
        return Optional.ofNullable((PotionComponent)stack.get(ModRegistry.POTION_COMPONENT)).map(PotionComponent::amplifier).map(amplifier -> amplifier > ConfigManager.SERVER.infusionMaximumPotency.getAsInt()).orElse(false);
    }

    protected static boolean isAllowedEffect(ResourceLocation location) {
        List allowed = (List)ConfigManager.SERVER.infusionAllowedEffects.get();
        return allowed.isEmpty() || allowed.contains(location.getNamespace()) || allowed.contains(location.toString());
    }

    protected static boolean isDeniedEffect(ResourceLocation location) {
        List denied = (List)ConfigManager.SERVER.infusionDeniedEffects.get();
        return denied.contains(location.getNamespace()) || denied.contains(location.toString());
    }

    protected MutableComponent translate(String key) {
        return Component.translatable((String)TranslationKey.tooltip(key)).withStyle(ChatFormatting.GRAY);
    }

    protected MutableComponent translate(String key, Object ... values) {
        return Component.translatable((String)TranslationKey.tooltip(key), (Object[])values);
    }

    protected MutableComponent withAmplifier(MutableComponent component, int amplifier) {
        return Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.translatable((String)("potion.potency." + amplifier))});
    }
}

