/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class AttributeReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("attribute");
    private final List<ResourceLocation> ids = new ArrayList<ResourceLocation>();
    private final Holder<Attribute> attribute;
    private final float value;
    private final AttributeModifier.Operation operation;

    private AttributeReward(Holder<Attribute> attribute, float value, AttributeModifier.Operation operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, AttributeReward::parse);
    }

    private static Result<AttributeReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(AttributeReward::parse, context));
    }

    private static Result<AttributeReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optAttribute = rootObject.get("attribute").andThen(attributeElement -> BuiltinJson.parseAttribute(attributeElement).andThen(attribute -> {
            Holder attributeEntry = BuiltInRegistries.ATTRIBUTE.wrapAsHolder(attribute);
            if (DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER).hasAttribute(attributeEntry)) {
                return Result.success(attributeEntry);
            }
            return Result.failure(attributeElement.getPath().createProblem("Expected a valid player attribute"));
        })).ifFailure(problems::add).getSuccess();
        Optional<Float> optValue = rootObject.getFloat("value").ifFailure(problems::add).getSuccess();
        Optional optOperation = rootObject.get("operation").andThen(BuiltinJson::parseAttributeOperation).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new AttributeReward((Holder<Attribute>)((Holder)optAttribute.orElseThrow()), optValue.orElseThrow().floatValue(), (AttributeModifier.Operation)optOperation.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public void update(RewardUpdateContext context) {
        int count = context.getCount();
        AttributeInstance instance = Objects.requireNonNull(context.getPlayer().getAttribute(this.attribute));
        while (this.ids.size() < count) {
            this.ids.add(SkillsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789")));
        }
        for (int i = 0; i < this.ids.size(); ++i) {
            ResourceLocation id = this.ids.get(i);
            if (instance.getModifier(id) == null) {
                if (i >= count) continue;
                instance.addTransientModifier(new AttributeModifier(id, (double)this.value, this.operation));
                continue;
            }
            if (i < count) continue;
            instance.removeModifier(id);
        }
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        for (ServerPlayer player : context.getServer().getPlayerList().getPlayers()) {
            AttributeInstance instance = Objects.requireNonNull(player.getAttribute(this.attribute));
            for (ResourceLocation id : this.ids) {
                instance.removeModifier(id);
            }
        }
        this.ids.clear();
    }
}

