/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.expression;

import java.util.Optional;

public class Lexer {
    private final String content;
    private int cursor;

    private Lexer(String content, int cursor) {
        this.content = content;
        this.cursor = cursor;
    }

    public static Lexer create(String content) {
        Lexer lexer = new Lexer(content, 0);
        lexer.skipWhitespace();
        return lexer;
    }

    public static Lexer copy(Lexer lexer) {
        return new Lexer(lexer.content, lexer.cursor);
    }

    private void skipWhitespace() {
        while (this.cursor < this.content.length() && Character.isWhitespace(this.content.charAt(this.cursor))) {
            ++this.cursor;
        }
    }

    public boolean consume(String token) {
        if (this.content.startsWith(token, this.cursor)) {
            this.cursor += token.length();
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    public Optional<String> consumeOther() {
        int end;
        for (end = this.cursor; end < this.content.length() && this.isOther(this.content.charAt(end)); ++end) {
        }
        if (this.cursor == end) {
            return Optional.empty();
        }
        String token = this.content.substring(this.cursor, end);
        this.cursor = end;
        this.skipWhitespace();
        return Optional.of(token);
    }

    private boolean isOther(char ch) {
        return ch >= '0' && ch <= '9' || ch == '.' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
    }

    public boolean isEnd() {
        return this.cursor == this.content.length();
    }
}

