/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.Variables;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerChunk;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerEntity;
import net.puffish.skillsmod.experience.source.builtin.util.TamedActivity;
import net.puffish.skillsmod.util.LegacyUtils;

public record DealDamageExperienceSource(Calculation<Data> calculation, Optional<AntiFarmingPerEntity> antiFarmingPerEntity, Optional<AntiFarmingPerChunk> antiFarmingPerChunk, TamedActivity tamedActivity) implements ExperienceSource
{
    private static final ResourceLocation ID = SkillsMod.createIdentifier("deal_damage");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, DealDamageExperienceSource::parse);
    }

    private static Result<DealDamageExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(rootObject -> DealDamageExperienceSource.parse(rootObject, context), context));
    }

    private static Result<DealDamageExperienceSource, Problem> parse(JsonObject rootObject, ExperienceSourceConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Variables variables = rootObject.get("variables").getSuccess().flatMap(variablesElement -> Variables.parse(variablesElement, PROTOTYPE, context).ifFailure(problems::add).getSuccess()).orElseGet(() -> Variables.create(Map.of()));
        Optional optCalculation = rootObject.get("experience").andThen(experienceElement -> Calculation.parse(experienceElement, variables, context)).ifFailure(problems::add).getSuccess();
        Optional<AntiFarmingPerEntity> antiFarmingPerEntity = rootObject.get("anti_farming_per_entity").orElse(LegacyUtils.wrapDeprecated(() -> rootObject.get("anti_farming"), 4, context)).getSuccess().flatMap(element -> AntiFarmingPerEntity.parse(element, context).ifFailure(problems::add).getSuccess());
        Optional<AntiFarmingPerChunk> antiFarmingPerChunk = rootObject.get("anti_farming_per_chunk").getSuccess().flatMap(element -> AntiFarmingPerChunk.parse(element, (ConfigContext)context).ifFailure(problems::add).getSuccess().flatMap(Function.identity()));
        TamedActivity tamed = rootObject.get("tamed").getSuccess().flatMap(element -> TamedActivity.parse(element).ifFailure(problems::add).getSuccess()).orElse(TamedActivity.EXCLUDE);
        if (problems.isEmpty()) {
            return Result.success(new DealDamageExperienceSource((Calculation)optCalculation.orElseThrow(), antiFarmingPerEntity, antiFarmingPerChunk, tamed));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_weapon_item_stack"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::weapon));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_damaged_living_entity"), BuiltinPrototypes.LIVING_ENTITY, OperationFactory.create(Data::entity));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_damage_source"), BuiltinPrototypes.DAMAGE_SOURCE, OperationFactory.create(Data::damageSource));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_dealt_damage"), BuiltinPrototypes.NUMBER, OperationFactory.create(data -> data.damage()));
    }

    public record Data(ServerPlayer player, LivingEntity entity, ItemStack weapon, float damage, DamageSource damageSource) {
    }
}

