/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public sealed interface IconConfig {
    public static Result<IconConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> IconConfig.parse(rootObject, context), context));
    }

    public static Result<IconConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optTypeElement = rootObject.get("type").ifFailure(problems::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> typeElement.getAsString().ifFailure(problems::add).getSuccess());
        Optional<JsonElement> optData = rootObject.get("data").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return IconConfig.build((String)optType.orElseThrow(), optData.orElseThrow(), optTypeElement.orElseThrow().getPath(), context);
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<IconConfig, Problem> build(String type, JsonElement dataElement, JsonPath typeElementPath, ConfigContext context) {
        return switch (type) {
            case "item" -> ItemIconConfig.parse(dataElement, context).mapSuccess(Function.identity());
            case "effect" -> EffectIconConfig.parse(dataElement, context).mapSuccess(Function.identity());
            case "texture" -> TextureIconConfig.parse(dataElement, context).mapSuccess(Function.identity());
            default -> Result.failure(typeElementPath.createProblem("Expected a valid icon type"));
        };
    }

    public record ItemIconConfig(ItemStack item) implements IconConfig
    {
        public static Result<ItemIconConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return BuiltinJson.parseItemStack(rootElement, (RegistryAccess)context.getServer().registryAccess()).mapSuccess(ItemIconConfig::new);
        }
    }

    public record EffectIconConfig(MobEffect effect) implements IconConfig
    {
        public static Result<EffectIconConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(EffectIconConfig::parse, context));
        }

        public static Result<EffectIconConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional optEffect = rootObject.get("effect").andThen(BuiltinJson::parseEffect).ifFailure(problems::add).getSuccess();
            if (problems.isEmpty()) {
                return Result.success(new EffectIconConfig((MobEffect)optEffect.orElseThrow()));
            }
            return Result.failure(Problem.combine(problems));
        }
    }

    public record TextureIconConfig(ResourceLocation texture) implements IconConfig
    {
        public static Result<TextureIconConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(TextureIconConfig::parse, context));
        }

        public static Result<TextureIconConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional optEffect = rootObject.get("texture").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            if (problems.isEmpty()) {
                return Result.success(new TextureIconConfig((ResourceLocation)optEffect.orElseThrow()));
            }
            return Result.failure(Problem.combine(problems));
        }
    }
}

