/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.commands.arguments.SkillArgumentType;
import net.puffish.skillsmod.util.CommandUtils;

public class SkillsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skills").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).then(Commands.argument((String)"skill", (ArgumentType)SkillArgumentType.skillFromCategory("category")).executes(SkillsCommand::unlock)))))).then(Commands.literal((String)"lock").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).then(Commands.argument((String)"skill", (ArgumentType)SkillArgumentType.skillFromCategory("category")).executes(SkillsCommand::lock)))))).then(Commands.literal((String)"reset").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(SkillsCommand::reset))));
    }

    private static int unlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Skill skill = SkillArgumentType.getSkillFromCategory(context, "skill", category);
        for (ServerPlayer player : players) {
            skill.unlock(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.unlock", category.getId(), skill.getId());
        return players.size();
    }

    private static int lock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Skill skill = SkillArgumentType.getSkillFromCategory(context, "skill", category);
        for (ServerPlayer player : players) {
            skill.lock(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.lock", category.getId(), skill.getId());
        return players.size();
    }

    private static int reset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (ServerPlayer player : players) {
            category.resetSkills(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.reset", category.getId());
        return players.size();
    }
}

