/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public sealed interface FrameConfig {
    public static FrameConfig createDefault() {
        return new AdvancementFrameConfig(AdvancementType.TASK);
    }

    public static Result<FrameConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().flatMap(LegacyUtils.wrapNoUnused(rootObject -> FrameConfig.parse(rootObject, context), context), failure -> BuiltinJson.parseFrame(rootElement).mapSuccess(AdvancementFrameConfig::new));
    }

    public static Result<FrameConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optTypeElement = rootObject.get("type").ifFailure(problems::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> typeElement.getAsString().ifFailure(problems::add).getSuccess());
        Optional<JsonElement> optData = rootObject.get("data").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return FrameConfig.build((String)optType.orElseThrow(), optData.orElseThrow(), optTypeElement.orElseThrow().getPath(), context);
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<FrameConfig, Problem> build(String type, JsonElement dataElement, JsonPath typeElementPath, ConfigContext context) {
        return switch (type) {
            case "advancement" -> AdvancementFrameConfig.parse(dataElement, context).mapSuccess(Function.identity());
            case "texture" -> TextureFrameConfig.parse(dataElement, context).mapSuccess(Function.identity());
            default -> Result.failure(typeElementPath.createProblem("Expected a valid icon type"));
        };
    }

    public record AdvancementFrameConfig(AdvancementType frame) implements FrameConfig
    {
        public static Result<AdvancementFrameConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(AdvancementFrameConfig::parse, context));
        }

        public static Result<AdvancementFrameConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional optEffect = rootObject.get("frame").andThen(BuiltinJson::parseFrame).ifFailure(problems::add).getSuccess();
            if (problems.isEmpty()) {
                return Result.success(new AdvancementFrameConfig((AdvancementType)optEffect.orElseThrow()));
            }
            return Result.failure(Problem.combine(problems));
        }
    }

    public record TextureFrameConfig(Optional<ResourceLocation> lockedTexture, ResourceLocation availableTexture, Optional<ResourceLocation> affordableTexture, ResourceLocation unlockedTexture, Optional<ResourceLocation> excludedTexture) implements FrameConfig
    {
        public static Result<TextureFrameConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
            return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(TextureFrameConfig::parse, context));
        }

        private static Result<TextureFrameConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional<ResourceLocation> optAffordableTexture = rootObject.get("affordable").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optAvailableTexture = rootObject.get("available").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<ResourceLocation> optLockedTexture = rootObject.get("locked").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optUnlockedTexture = rootObject.get("unlocked").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<ResourceLocation> optExcludedTexture = rootObject.get("excluded").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            if (problems.isEmpty()) {
                return Result.success(new TextureFrameConfig(optLockedTexture, (ResourceLocation)optAvailableTexture.orElseThrow(), optAffordableTexture, (ResourceLocation)optUnlockedTexture.orElseThrow(), optExcludedTexture));
            }
            return Result.failure(Problem.combine(problems));
        }
    }
}

