/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.api.PuffishAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Inventory.class})
public class PlayerInventoryMixin {
    @ModifyReturnValue(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F"}, at={@At(value="RETURN")})
    private float injectAtGetBlockBreakingSpeed(float speed) {
        if (speed <= 1.0f) {
            return speed;
        }
        Inventory inventory = (Inventory)this;
        Player player = inventory.player;
        Item item = inventory.getSelected().getItem();
        DynamicModification dm = DynamicModification.create();
        if (item instanceof PickaxeItem) {
            dm.withPositive(PuffishAttributes.PICKAXE_SPEED, (LivingEntity)player);
        }
        if (item instanceof AxeItem) {
            dm.withPositive(PuffishAttributes.AXE_SPEED, (LivingEntity)player);
        }
        if (item instanceof ShovelItem) {
            dm.withPositive(PuffishAttributes.SHOVEL_SPEED, (LivingEntity)player);
        }
        dm.withPositive(PuffishAttributes.MINING_SPEED, (LivingEntity)player);
        return dm.applyTo(speed);
    }
}

