/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.api.PuffishAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1100)
public abstract class PlayerEntityMixin {
    private static final double VANILLA_KNOCKBACK = 0.4;

    @ModifyExpressionValue(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtCreateLivingAttributes(AttributeSupplier.Builder builder) {
        return builder.add(PuffishAttributes.STAMINA).add(PuffishAttributes.FORTUNE).add(PuffishAttributes.MINING_SPEED).add(PuffishAttributes.BREAKING_SPEED).add(PuffishAttributes.PICKAXE_SPEED).add(PuffishAttributes.AXE_SPEED).add(PuffishAttributes.SHOVEL_SPEED).add(PuffishAttributes.SPRINTING_SPEED).add(PuffishAttributes.KNOCKBACK).add(PuffishAttributes.REPAIR_COST).add(PuffishAttributes.NATURAL_REGENERATION).add(PuffishAttributes.TAMED_DAMAGE).add(PuffishAttributes.TAMED_RESISTANCE).add(PuffishAttributes.EXPERIENCE);
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;doPostAttackEffects(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)V")})
    private void injectAtAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        double knockback = DynamicModification.create().withPositive(PuffishAttributes.KNOCKBACK, (LivingEntity)player).applyTo(0.4) - 0.4;
        float yaw = player.getYRot() * ((float)Math.PI / 180);
        float sin = Mth.sin((float)yaw);
        float cos = Mth.cos((float)yaw);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.knockback(knockback, (double)sin, (double)(-cos));
        } else {
            target.push((double)(-sin) * knockback, 0.0, (double)cos * knockback);
        }
    }

    @ModifyReturnValue(method={"getSpeed()F"}, at={@At(value="RETURN")})
    private float injectAtGetMovementSpeed(float speed) {
        Player player = (Player)this;
        if (!player.isSprinting()) {
            return speed;
        }
        return DynamicModification.create().withPositive(PuffishAttributes.SPRINTING_SPEED, (LivingEntity)player).applyTo(speed);
    }

    @Inject(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;)F", "getDigSpeed(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectUtil;hasDigSpeed(Lnet/minecraft/world/entity/LivingEntity;)Z")})
    private void injectAtGetBlockBreakingSpeed(CallbackInfoReturnable<Float> cir, @Local LocalFloatRef speed) {
        Player player = (Player)this;
        speed.set(DynamicModification.create().withPositive(PuffishAttributes.BREAKING_SPEED, (LivingEntity)player).applyTo(speed.get()));
    }
}

