/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.api.PuffishAttributes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ApplyBonusCount.class})
public abstract class ApplyBonusLootFunctionMixin {
    @Shadow
    @Final
    private Holder<Enchantment> enchantment;

    @ModifyVariable(method={"run(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/storage/loot/LootContext;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="STORE"), ordinal=0)
    private int modifyVariableAtProcess(int value, ItemStack itemStack, LootContext context) {
        Object object;
        if (this.enchantment.is(Enchantments.FORTUNE) && (object = context.getParamOrNull(LootContextParams.THIS_ENTITY)) instanceof Player) {
            Player player = (Player)object;
            float fortune = DynamicModification.create().withPositive(PuffishAttributes.FORTUNE, (LivingEntity)player).applyTo(value);
            value = (int)fortune;
            if (context.getRandom().nextFloat() < fortune - (float)value) {
                ++value;
            }
        }
        return value;
    }
}

