/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks;

import de.cadentem.pufferfish_unofficial_additions.PUA;
import de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks.Data;
import de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks.SpellCastingExperienceSource;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.SkillsAPI;
import org.jetbrains.annotations.Nullable;

public class ISSEvents {
    public static void grantSpellExperience(SpellOnCastEvent event) {
        int manaCost;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer caster = (ServerPlayer)player;
        Holder school = ISSEvents.getHolder(caster.registryAccess(), SchoolRegistry.SCHOOL_REGISTRY_KEY, event.getSchoolType().getId());
        Holder spellHolder = ISSEvents.getHolder(caster.registryAccess(), SpellRegistry.SPELL_REGISTRY_KEY, ResourceLocation.tryParse((String)event.getSpellId()));
        if (school == null || spellHolder == null) {
            PUA.LOG.debug("School [{}] or spell [{}] does not exist / is not registered", (Object)event.getSchoolType().getId(), (Object)event.getSpellId());
            return;
        }
        ItemStack mainHand = caster.getMainHandItem();
        ItemStack spellbook = Utils.getPlayerSpellbookStack((Player)caster);
        if (spellbook == null) {
            spellbook = ItemStack.EMPTY;
        }
        AbstractSpell spell = (AbstractSpell)spellHolder.value();
        int spellLevel = event.getSpellLevel();
        SpellRarity rarity = spell.getRarity(spellLevel);
        int minLevelRarity = spell.getMinLevelForRarity(rarity);
        int n = manaCost = event.getCastSource().consumesMana() ? spell.getManaCost(spellLevel) : 0;
        int manaCostPerSecond = event.getCastSource().consumesMana() ? (spell.getCastType() == CastType.CONTINUOUS ? manaCost * 2 : 0) : 0;
        int castDurationTicks = spell.getCastType() == CastType.CONTINUOUS ? spell.getEffectiveCastTime(spellLevel, (LivingEntity)caster) : 0;
        double castDuration = (double)castDurationTicks / 20.0;
        double castChargeTime = spell.getCastType() == CastType.LONG ? (double)spell.getEffectiveCastTime(spellLevel, (LivingEntity)caster) / 20.0 : 0.0;
        double cooldown = (double)MagicManager.getEffectiveSpellCooldown((AbstractSpell)spell, (Player)caster, (CastSource)event.getCastSource()) / 20.0;
        int expectedTicks = spell.getCastType() == CastType.CONTINUOUS ? castDurationTicks / 10 : 1;
        Data data = new Data(caster, mainHand, spellbook, school, spellHolder, rarity, spellLevel, minLevelRarity, manaCost, manaCostPerSecond, castDuration, castChargeTime, cooldown, expectedTicks);
        PUA.LOG.debug("Spell experience source data: [{}]", (Object)data);
        SkillsAPI.updateExperienceSources((ServerPlayer)caster, SpellCastingExperienceSource.class, source -> source.getValue(data));
    }

    @Nullable
    private static <T> Holder<T> getHolder(RegistryAccess access, ResourceKey<Registry<T>> key, ResourceLocation resource) {
        return access.registryOrThrow(key).getHolder(ResourceKey.create(key, (ResourceLocation)resource)).orElse(null);
    }
}

