/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.rewards;

import de.cadentem.pufferfish_unofficial_additions.PUA;
import de.cadentem.pufferfish_unofficial_additions.misc.ModificationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectReward
implements Reward {
    public static final ResourceLocation ID = PUA.location("effect");
    public static final Map<UUID, List<Data>> DATA = new HashMap<UUID, List<Data>>();
    private static final DurationModification EMPTY_DURATION_MODIFICATION = new DurationModification(Operation.NONE, 0.0);
    private final Holder<MobEffect> effect;
    private final Type type;
    private final DurationModification durationModification;
    private final int amplifier;
    private final boolean showIcon;

    private EffectReward(Holder<MobEffect> effect, Type type, DurationModification durationModification, int amplifier, boolean showIcon) {
        this.effect = effect;
        this.type = type;
        this.durationModification = durationModification;
        this.amplifier = amplifier;
        this.showIcon = showIcon;
    }

    public static void register() {
        SkillsAPI.registerReward((ResourceLocation)ID, EffectReward::parse);
    }

    public static boolean isImmune(UUID uuid, Holder<MobEffect> effect, int amplifier) {
        return EffectReward.getData(uuid).stream().anyMatch(data -> data.type == Type.IMMUNE && data.effect == effect && amplifier <= data.amplifier);
    }

    private static Result<EffectReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(EffectReward::parse);
    }

    private static Result<EffectReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional effect = rootObject.get("effect").andThen(BuiltinJson::parseEffectOrEffectTag).ifFailure(problems::add).getSuccess();
        Optional typeRaw = rootObject.getString("type").ifFailure(problems::add).getSuccess();
        Optional amplifierOptional = rootObject.getInt("amplifier").ifFailure(problems::add).getSuccess();
        boolean showIcon = rootObject.get("show_icon").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(false);
        if (typeRaw.isPresent()) {
            Type type = Type.get((String)typeRaw.get());
            DurationModification durationModification = EMPTY_DURATION_MODIFICATION;
            if (type == Type.MODIFY && rootObject.getJson().has("duration_modification")) {
                String data;
                Optional durationModificationRaw = rootObject.getString("duration_modification").ifFailure(problems::add).getSuccess();
                if (durationModificationRaw.isPresent() && !(data = (String)durationModificationRaw.get()).isBlank()) {
                    durationModification = new DurationModification(Operation.get(data.substring(0, 1)), Double.parseDouble(data.substring(1)));
                }
            }
            if (amplifierOptional.isPresent()) {
                HolderSet set;
                int amplifier = (Integer)amplifierOptional.get();
                if (!(amplifier >= 0 && amplifier <= 255 || type != Type.GRANT && type != Type.IMMUNE)) {
                    problems.add(Problem.message((String)"The amplifier has to be between 0 and 255"));
                }
                if (problems.isEmpty() && (set = (HolderSet)effect.orElseThrow()).size() > 0) {
                    return Result.success((Object)new EffectReward((Holder<MobEffect>)set.get(0), type, durationModification, amplifier, showIcon));
                }
            }
        }
        return Result.failure((Object)Problem.combine(problems));
    }

    public static boolean shouldRemove(UUID uuid, Holder<MobEffect> effect, int amplifier) {
        return EffectReward.getData(uuid).stream().anyMatch(data -> data.type == Type.GRANT && data.effect == effect && data.amplifier == amplifier);
    }

    public static void applyEffects(ServerPlayer player) {
        EffectReward.getData(player.getUUID()).stream().filter(data -> data.type == Type.GRANT).forEach(data -> {
            MobEffectInstance instance = player.getEffect(data.effect);
            if (instance != null && instance.getAmplifier() > data.amplifier && instance.isInfiniteDuration()) {
                return;
            }
            EffectReward.addEffect(player, data);
        });
    }

    @Nullable
    public static MobEffectInstance modifyEffect(ServerPlayer player, MobEffectInstance instance) {
        if (!((ModificationHandler)instance).pufferfish_unofficial_additions$wasModified()) {
            Holder effect = instance.getEffect();
            int modifiedAmplifier = EffectReward.getModifiedAmplifier(player.getUUID(), (Holder<MobEffect>)effect, instance.getAmplifier());
            int modifiedDuration = instance.getDuration();
            if (!instance.isInfiniteDuration()) {
                modifiedDuration = EffectReward.getModifiedDuration(player.getUUID(), (Holder<MobEffect>)effect, instance.getDuration());
            }
            if (modifiedAmplifier < 0 || !instance.isInfiniteDuration() && modifiedDuration <= 0) {
                return null;
            }
            if (instance.getDuration() != modifiedDuration || instance.getAmplifier() != modifiedAmplifier) {
                MobEffectInstance modifiedInstance = new MobEffectInstance(effect, modifiedDuration, modifiedAmplifier, instance.isAmbient(), instance.isVisible(), instance.showIcon());
                ((ModificationHandler)modifiedInstance).pufferfish_unofficial_additions$setModified(true);
                return modifiedInstance;
            }
        }
        return instance;
    }

    private static int getModifiedDuration(UUID uuid, Holder<MobEffect> effect, int duration) {
        List<Data> modifications = EffectReward.getData(uuid).stream().filter(data -> data.type == Type.MODIFY && data.effect == effect).toList();
        for (Data data2 : modifications) {
            DurationModification modification = data2.durationModification;
            if (modification == EMPTY_DURATION_MODIFICATION) continue;
            duration = switch (modification.operation.ordinal()) {
                case 0 -> (int)((double)duration + modification.amount);
                case 1 -> (int)((double)duration - modification.amount);
                case 2 -> (int)((double)duration * modification.amount);
                case 3 -> {
                    if (modification.amount != 0.0) {
                        yield (int)((double)duration / modification.amount);
                    }
                    yield duration;
                }
                default -> duration;
            };
        }
        return Math.max(0, duration);
    }

    private static int getModifiedAmplifier(UUID uuid, Holder<MobEffect> effect, int amplifier) {
        List<Data> modifications = EffectReward.getData(uuid).stream().filter(data -> data.type == Type.MODIFY && data.effect == effect).toList();
        for (Data data2 : modifications) {
            amplifier += data2.amplifier;
        }
        return amplifier;
    }

    public static void clearData(UUID uuid) {
        DATA.remove(uuid);
    }

    public void update(RewardUpdateContext context) {
        ServerPlayer player = context.getPlayer();
        int count = context.getCount();
        List<Data> data = EffectReward.getData(player.getUUID());
        if (count == 0) {
            data.removeIf(this::matches);
            if (this.type == Type.GRANT) {
                this.removeEffect(player);
            }
        } else {
            int active = count;
            for (int i = 0; i < data.size(); ++i) {
                Data entry = data.get(i);
                if (!this.matches(entry)) continue;
                if (active == 0) {
                    data.remove(i);
                    --i;
                    continue;
                }
                --active;
            }
            Data entry = new Data(this.effect, this.type, this.durationModification, this.amplifier, this.showIcon);
            for (int i = 0; i < active; ++i) {
                data.add(entry);
            }
            if (this.type == Type.GRANT) {
                EffectReward.addEffect(player, entry);
            }
        }
    }

    public void dispose(RewardDisposeContext context) {
        context.getServer().getPlayerList().getPlayers().forEach(player -> {
            EffectReward.getData(player.getUUID()).removeIf(this::matches);
            if (this.type == Type.GRANT) {
                this.removeEffect((ServerPlayer)player);
            }
        });
    }

    private static List<Data> getData(UUID uuid) {
        return DATA.computeIfAbsent(uuid, key -> new ArrayList());
    }

    private void removeEffect(ServerPlayer player) {
        MobEffectInstance instance = player.getEffect(this.effect);
        if (instance != null && instance.isInfiniteDuration() && this.matches(instance)) {
            player.removeEffect(this.effect);
        }
    }

    private static void addEffect(ServerPlayer player, Data data) {
        player.addEffect(new MobEffectInstance(data.effect, -1, data.amplifier, false, false, data.showIcon()));
    }

    private boolean matches(Data data) {
        return data.effect == this.effect && data.type == this.type && data.durationModification == this.durationModification && data.amplifier == this.amplifier;
    }

    private boolean matches(@NotNull MobEffectInstance instance) {
        return instance.getEffect() == this.effect && instance.getAmplifier() == this.amplifier;
    }

    public static enum Type {
        GRANT,
        MODIFY,
        IMMUNE;


        public static Type get(String type) {
            return switch (type.toLowerCase()) {
                case "grant" -> GRANT;
                case "immune" -> IMMUNE;
                case "modify" -> MODIFY;
                default -> throw new IllegalArgumentException("Supplied invalid type: " + type);
            };
        }
    }

    public record DurationModification(Operation operation, double amount) {
    }

    public static enum Operation {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("x"),
        DIVIDE("/"),
        NONE("");

        private final String key;

        private Operation(String key) {
            this.key = key;
        }

        public static Operation get(String key) {
            for (Operation operation : Operation.values()) {
                if (!operation.key.equals(key)) continue;
                return operation;
            }
            return NONE;
        }
    }

    public record Data(Holder<MobEffect> effect, Type type, DurationModification durationModification, int amplifier, boolean showIcon) {
    }
}

