/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.events;

import de.cadentem.pufferfish_unofficial_additions.experience.FishingExperienceSource;
import de.cadentem.pufferfish_unofficial_additions.rewards.EffectReward;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.puffish.skillsmod.api.SkillsAPI;

@EventBusSubscriber
public class GameEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void grantFishingExperience(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.getDrops().isEmpty()) {
                SkillsAPI.updateExperienceSources((ServerPlayer)serverPlayer, FishingExperienceSource.class, source -> source.getValue(serverPlayer, serverPlayer.getMainHandItem(), ItemStack.EMPTY));
            } else {
                event.getDrops().forEach(drop -> SkillsAPI.updateExperienceSources((ServerPlayer)serverPlayer, FishingExperienceSource.class, source -> source.getValue(serverPlayer, serverPlayer.getMainHandItem(), (ItemStack)drop)));
            }
        }
    }

    @SubscribeEvent
    public static void immuneEffects(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            Holder effect = event.getEffectInstance().getEffect();
            int amplifier = event.getEffectInstance().getAmplifier();
            if (EffectReward.isImmune(player.getUUID(), (Holder<MobEffect>)effect, amplifier)) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        }
    }

    @SubscribeEvent
    public static void retainEffects(MobEffectEvent.Remove event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (instance != null && instance.isInfiniteDuration()) {
                Holder effect = instance.getEffect();
                int amplifier = instance.getAmplifier();
                if (EffectReward.shouldRemove(player.getUUID(), (Holder<MobEffect>)effect, amplifier)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void retainEffects(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            EffectReward.applyEffects(player);
        }
    }

    @SubscribeEvent
    public static void clearData(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EffectReward.clearData(player2.getUUID());
        }
    }
}

