/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks;

import de.cadentem.pufferfish_unofficial_additions.compat.irons_spellbooks.ISPrototypes;
import de.cadentem.pufferfish_unofficial_additions.misc.ExtendedJson;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class SchoolCondition
implements Operation<Holder<SchoolType>, Boolean> {
    private final HolderSet<SchoolType> schoolEntries;

    private SchoolCondition(HolderSet<SchoolType> schoolEntries) {
        this.schoolEntries = schoolEntries;
    }

    public static void register() {
        ISPrototypes.SCHOOL.registerOperation(SkillsMod.createIdentifier((String)"test"), BuiltinPrototypes.BOOLEAN, SchoolCondition::parse);
    }

    public static Result<SchoolCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(SchoolCondition::parse);
    }

    public static Result<SchoolCondition, Problem> parse(JsonObject rootObject) {
        ArrayList problems = new ArrayList();
        Optional optional = rootObject.get("school").andThen(ExtendedJson::parseSchool).ifFailure(problems::add).getSuccess();
        return problems.isEmpty() ? Result.success((Object)new SchoolCondition((HolderSet<SchoolType>)((HolderSet)optional.orElseThrow()))) : Result.failure((Object)Problem.combine(problems));
    }

    public Optional<Boolean> apply(Holder<SchoolType> school) {
        return Optional.of(this.schoolEntries.contains(school));
    }
}

