/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry.instrumentation.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.creeperhost.polylib.io.sentry.IHub;
import net.creeperhost.polylib.io.sentry.ISpan;
import net.creeperhost.polylib.io.sentry.SpanStatus;
import net.creeperhost.polylib.io.sentry.util.Platform;
import net.creeperhost.polylib.io.sentry.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileIOSpanManager {
    @Nullable
    private final ISpan currentSpan;
    @Nullable
    private final File file;
    private final boolean isSendDefaultPii;
    @NotNull
    private SpanStatus spanStatus = SpanStatus.OK;
    private long byteCount;

    @Nullable
    static ISpan startSpan(@NotNull IHub hub, @NotNull String op) {
        ISpan parent = hub.getSpan();
        return parent != null ? parent.startChild(op) : null;
    }

    FileIOSpanManager(@Nullable ISpan currentSpan, @Nullable File file, boolean isSendDefaultPii) {
        this.currentSpan = currentSpan;
        this.file = file;
        this.isSendDefaultPii = isSendDefaultPii;
    }

    <T> T performIO(@NotNull FileIOCallable<T> operation) throws IOException {
        try {
            long resUnboxed;
            T result = operation.call();
            if (result instanceof Integer) {
                int resUnboxed2 = (Integer)result;
                if (resUnboxed2 != -1) {
                    this.byteCount += (long)resUnboxed2;
                }
            } else if (result instanceof Long && (resUnboxed = ((Long)result).longValue()) != -1L) {
                this.byteCount += resUnboxed;
            }
            return result;
        }
        catch (IOException exception) {
            this.spanStatus = SpanStatus.INTERNAL_ERROR;
            if (this.currentSpan != null) {
                this.currentSpan.setThrowable(exception);
            }
            throw exception;
        }
    }

    void finish(@NotNull Closeable delegate) throws IOException {
        try {
            delegate.close();
        }
        catch (IOException exception) {
            this.spanStatus = SpanStatus.INTERNAL_ERROR;
            if (this.currentSpan != null) {
                this.currentSpan.setThrowable(exception);
            }
            throw exception;
        }
        finally {
            this.finishSpan();
        }
    }

    private void finishSpan() {
        if (this.currentSpan != null) {
            String byteCountToString = StringUtils.byteCountToString(this.byteCount);
            if (this.file != null) {
                String description = this.file.getName() + " (" + byteCountToString + ")";
                this.currentSpan.setDescription(description);
                if (Platform.isAndroid() || this.isSendDefaultPii) {
                    this.currentSpan.setData("file.path", this.file.getAbsolutePath());
                }
            } else {
                this.currentSpan.setDescription(byteCountToString);
            }
            this.currentSpan.setData("file.size", this.byteCount);
            this.currentSpan.finish(this.spanStatus);
        }
    }

    @FunctionalInterface
    static interface FileIOCallable<T> {
        public T call() throws IOException;
    }
}

