/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModularGuiContainerMenu
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Inventory inventory;
    public final List<SlotGroup> slotGroups = new ArrayList<SlotGroup>();
    public final Map<Slot, SlotGroup> slotGroupMap = new HashMap<Slot, SlotGroup>();
    public final Map<Integer, List<Slot>> zonedSlots = new HashMap<Integer, List<Slot>>();
    public final List<DataSync<?>> dataSyncs = new ArrayList();

    protected ModularGuiContainerMenu(@Nullable MenuType<?> menuType, int containerId, Inventory inventory) {
        super(menuType, containerId);
        this.inventory = inventory;
    }

    protected SlotGroup createSlotGroup(int zoneId, int ... quickMoveTo) {
        SlotGroup group = new SlotGroup(this, zoneId, quickMoveTo);
        this.slotGroups.add(group);
        return group;
    }

    protected SlotGroup playerSlotGroup() {
        return this.createSlotGroup(0, 1);
    }

    protected SlotGroup remoteSlotGroup() {
        return this.createSlotGroup(1, 0);
    }

    @Deprecated(forRemoval=true)
    public void setServerToClientPacketHandler(BiConsumer<ServerPlayer, Consumer<RegistryFriendlyByteBuf>> serverToClientPacketHandler) {
    }

    @Deprecated(forRemoval=true)
    public void setClientToServerPacketHandler(Consumer<Consumer<RegistryFriendlyByteBuf>> clientToServerPacketHandler) {
    }

    public void sendPacketToClient(int packetId, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        Player player = this.inventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PolyLibNetwork.sendContainerPacketToClient(serverPlayer, buf -> {
                buf.writeByte(this.containerId);
                buf.writeByte((int)((byte)packetId));
                packetWriter.accept((RegistryFriendlyByteBuf)buf);
            });
        }
    }

    public void sendPacketToServer(int packetId, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        PolyLibNetwork.sendContainerPacketToServer(this.inventory.player.registryAccess(), buf -> {
            buf.writeByte(this.containerId);
            buf.writeByte((int)((byte)packetId));
            packetWriter.accept((RegistryFriendlyByteBuf)buf);
        });
    }

    public static void handlePacketFromClient(Player player, RegistryFriendlyByteBuf packet) {
        byte containerId = packet.readByte();
        int packetId = packet.readByte() & 0xFF;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ModularGuiContainerMenu) {
            ModularGuiContainerMenu menu = (ModularGuiContainerMenu)abstractContainerMenu;
            if (menu.containerId == containerId) {
                menu.handlePacketFromClient(player, packetId, packet);
            }
        }
    }

    public void handlePacketFromClient(Player player, int packetId, RegistryFriendlyByteBuf packet) {
    }

    public static void handlePacketFromServer(Player player, RegistryFriendlyByteBuf packet) {
        byte containerId = packet.readByte();
        int packetId = packet.readByte() & 0xFF;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ModularGuiContainerMenu) {
            ModularGuiContainerMenu menu = (ModularGuiContainerMenu)abstractContainerMenu;
            if (menu.containerId == containerId) {
                menu.handlePacketFromServer(player, packetId, packet);
            }
        }
    }

    public void handlePacketFromServer(Player player, int packetId, RegistryFriendlyByteBuf packet) {
        if (packetId == 255) {
            int index = packet.readByte() & 0xFF;
            if (this.dataSyncs.size() > index) {
                this.dataSyncs.get(index).handleSyncPacket(packet);
            }
        }
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        return ItemStack.matches((ItemStack)stack1, (ItemStack)stack2);
    }

    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        Slot slot = this.getSlot(slotIndex);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        SlotGroup group = this.slotGroupMap.get(slot);
        if (group == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack result = stack.copy();
        boolean movedAnything = false;
        for (Integer zone : group.quickMoveTo) {
            if (!this.zonedSlots.containsKey(zone)) {
                LOGGER.warn("Attempted to quick move to zone id {} but there are no slots assigned to this zone! This is a bug!", (Object)zone);
                continue;
            }
            if (!this.moveItemStackTo(stack, this.zonedSlots.get(zone), false)) continue;
            movedAnything = true;
            break;
        }
        if (!movedAnything) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, stack);
        return result;
    }

    protected boolean moveItemStackTo(ItemStack stack, List<Slot> targets, boolean reverse) {
        ItemStack itemStack2;
        Slot slot;
        int start = 0;
        int end = targets.size();
        boolean moved = false;
        int position = start;
        if (reverse) {
            position = end - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverse ? position >= end : position < start)) {
                slot = targets.get(position);
                itemStack2 = slot.getItem();
                if (!itemStack2.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack2)) {
                    int l = itemStack2.getCount() + stack.getCount();
                    if (l <= Math.min(stack.getMaxStackSize(), slot.getMaxStackSize(stack))) {
                        stack.setCount(0);
                        itemStack2.setCount(l);
                        slot.setChanged();
                        moved = true;
                    } else if (itemStack2.getCount() < Math.min(stack.getMaxStackSize(), slot.getMaxStackSize(stack))) {
                        stack.shrink(stack.getMaxStackSize() - itemStack2.getCount());
                        itemStack2.setCount(stack.getMaxStackSize());
                        slot.setChanged();
                        moved = true;
                    }
                }
                if (reverse) {
                    --position;
                    continue;
                }
                ++position;
            }
        }
        if (!stack.isEmpty()) {
            position = reverse ? end - 1 : start;
            while (!(!reverse ? position >= end : position < start)) {
                slot = targets.get(position);
                itemStack2 = slot.getItem();
                if (itemStack2.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize(stack)) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize(stack)));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    moved = true;
                    break;
                }
                if (reverse) {
                    --position;
                    continue;
                }
                ++position;
            }
        }
        return moved;
    }

    public void mapSlot(Slot slot, SlotGroup slotGroup) {
        this.slotGroupMap.put(slot, slotGroup);
        this.zonedSlots.computeIfAbsent(slotGroup.zone, e -> new ArrayList()).add(slot);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.dataSyncs.forEach(DataSync::detectAndSend);
    }
}

