/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.render.fluid;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.creeperhost.polylib.client.model.Model3D;
import net.creeperhost.polylib.client.render.fluid.FluidRenderMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;

public class FluidRenderHelper {
    public static final FluidRenderMap<Int2ObjectMap<Model3D>> CACHED_FLUIDS = new FluidRenderMap();
    public static final int STAGES = 1400;

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(spriteLocation);
    }

    public static Model3D getFluidModel(FluidStack fluid, int stage) {
        if (CACHED_FLUIDS.containsKey(fluid) && ((Int2ObjectMap)CACHED_FLUIDS.get(fluid)).containsKey(stage)) {
            return (Model3D)((Int2ObjectMap)CACHED_FLUIDS.get(fluid)).get(stage);
        }
        Model3D model = new Model3D();
        model.setTexture(FluidRenderMap.getFluidTexture(fluid, FluidRenderMap.FluidType.STILL));
        if (FluidStackHooks.getStillTexture((Fluid)fluid.getFluid()) != null) {
            model.minX = 0.135f;
            model.minY = 0.0725f;
            model.minZ = 0.135f;
            model.maxX = 0.865f;
            model.maxY = 0.0525f + 0.875f * ((float)stage / 1400.0f);
            model.maxZ = 0.865f;
        }
        ((Int2ObjectMap)CACHED_FLUIDS.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }

    public static float getScale(int stored, int capacity, boolean empty) {
        return (float)stored / (float)capacity;
    }
}

