/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.desht.pneumaticcraft.datagen.ModAdvancementProvider;
import me.desht.pneumaticcraft.datagen.ModBiomeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModBlockTagsProvider;
import me.desht.pneumaticcraft.datagen.ModDamageTypeProvider;
import me.desht.pneumaticcraft.datagen.ModDamageTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModEntityTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModFluidTagsProvider;
import me.desht.pneumaticcraft.datagen.ModGLMProvider;
import me.desht.pneumaticcraft.datagen.ModItemTagsProvider;
import me.desht.pneumaticcraft.datagen.ModLootTablesProvider;
import me.desht.pneumaticcraft.datagen.ModPoiTypeTagsProvider;
import me.desht.pneumaticcraft.datagen.ModRecipeProvider;
import me.desht.pneumaticcraft.datagen.ModStructureTagsProvider;
import me.desht.pneumaticcraft.datagen.ModWorldGenProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="pneumaticcraft")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(generator, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTablesProvider(generator, lookupProvider));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(generator, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(generator, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModFluidTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGLMProvider(generator, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPoiTypeTagsProvider(generator, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModStructureTagsProvider(generator, lookupProvider, event.getExistingFileHelper()));
        DataGenerators.makeProviders(generator.getPackOutput(), lookupProvider, existingFileHelper).forEach(p -> generator.addProvider(event.includeServer(), p));
    }

    public static List<DataProvider> makeProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> vanillaRegistries, ExistingFileHelper efh) {
        RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModWorldGenProvider.ConfiguredFeatures::bootstrap).add(Registries.PLACED_FEATURE, ModWorldGenProvider.PlacedFeatures::bootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ModWorldGenProvider.BiomeModifiers::bootstrap).add(Registries.DAMAGE_TYPE, ModDamageTypeProvider::bootstrap);
        return List.of(new DatapackBuiltinEntriesProvider(output, vanillaRegistries, builder, Set.of("pneumaticcraft")), new ModDamageTypeTagsProvider(output, DataGenerators.append(vanillaRegistries, builder), efh));
    }

    private static CompletableFuture<HolderLookup.Provider> append(CompletableFuture<HolderLookup.Provider> original, RegistrySetBuilder builder) {
        return RegistryPatchGenerator.createLookup(original, (RegistrySetBuilder)builder).thenApply(RegistrySetBuilder.PatchedRegistries::full);
    }
}

