/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.BiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.Validate;

public class CodecUtil {
    public static Codec<BitSet> bitSetCodec(int nBits) {
        Validate.isTrue((nBits > 0 && nBits <= 8 ? 1 : 0) != 0, (String)"only 1..8 bits supported!", (Object[])new Object[0]);
        return Codec.BYTE.xmap(b -> CodecUtil.fromByte(b, nBits), CodecUtil::toByte);
    }

    public static StreamCodec<ByteBuf, BitSet> bitSetStreamCodec(int nBits) {
        Validate.isTrue((nBits > 0 && nBits <= 8 ? 1 : 0) != 0, (String)"only 1..8 bits supported!", (Object[])new Object[0]);
        return StreamCodec.of((buf, bitSet) -> buf.writeByte((int)CodecUtil.toByte(bitSet)), buf -> CodecUtil.fromByte(buf.readByte(), nBits));
    }

    private static BitSet fromByte(byte b, int nBits) {
        BitSet res = new BitSet(nBits);
        for (int i = 0; i < nBits; ++i) {
            res.set(i, (b & 1 << i) != 0);
        }
        return res;
    }

    private static byte toByte(BitSet set) {
        byte[] a = set.toByteArray();
        return a.length == 0 ? (byte)0 : a[0];
    }

    public static <K, T> Codec<MapCodec<? extends T>> simpleDispatchCodec(Codec<K> keyCodec, BiMap<K, MapCodec<? extends T>> map) {
        return keyCodec.comapFlatMap(key -> {
            MapCodec x = (MapCodec)map.get(key);
            return x == null ? DataResult.error(() -> "unknown type " + String.valueOf(key)) : DataResult.success((Object)x);
        }, mapCodec -> map.inverse().get(mapCodec));
    }
}

