/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkCache
implements CollisionGetter {
    protected final int chunkX;
    protected final int chunkZ;
    protected final ChunkAccess[][] chunks;
    protected boolean empty;
    protected final Level world;

    public ChunkCache(Level worldIn, BlockPos pos1, BlockPos pos2) {
        int z;
        int x;
        this.world = worldIn;
        this.chunkX = pos1.getX() >> 4;
        this.chunkZ = pos1.getZ() >> 4;
        int endX = pos2.getX() >> 4;
        int endZ = pos2.getZ() >> 4;
        this.chunks = new ChunkAccess[endX - this.chunkX + 1][endZ - this.chunkZ + 1];
        this.empty = true;
        for (x = this.chunkX; x <= endX; ++x) {
            for (z = this.chunkZ; z <= endZ; ++z) {
                this.chunks[x - this.chunkX][z - this.chunkZ] = this.world.getChunk(x, z, ChunkStatus.FULL, true);
            }
        }
        for (x = pos1.getX() >> 4; x <= pos2.getX() >> 4; ++x) {
            for (z = pos1.getZ() >> 4; z <= pos2.getZ() >> 4; ++z) {
                ChunkAccess ichunk = this.chunks[x - this.chunkX][z - this.chunkZ];
                if (ichunk == null || ichunk.isYSpaceEmpty(pos1.getY(), pos2.getY())) continue;
                this.empty = false;
                return;
            }
        }
    }

    private ChunkAccess getChunk(BlockPos pos) {
        return this.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
    }

    private ChunkAccess getChunk(int chunkX, int chunkZ) {
        int x = chunkX - this.chunkX;
        int z = chunkZ - this.chunkZ;
        if (x >= 0 && x < this.chunks.length && z >= 0 && z < this.chunks[x].length) {
            ChunkAccess ichunk = this.chunks[x][z];
            return ichunk != null ? ichunk : new EmptyLevelChunk(this.world, new ChunkPos(chunkX, chunkZ), (Holder)this.world.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS));
        }
        return new EmptyLevelChunk(this.world, new ChunkPos(chunkX, chunkZ), (Holder)this.world.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS));
    }

    public WorldBorder getWorldBorder() {
        return this.world.getWorldBorder();
    }

    public BlockGetter getChunkForCollisions(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ);
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity pEntity, AABB pCollisionBox) {
        return Collections.emptyList();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        ChunkAccess ichunk = this.getChunk(pos);
        return ichunk.getBlockEntity(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        if (this.world.isOutsideBuildHeight(pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        ChunkAccess ichunk = this.getChunk(pos);
        return ichunk.getBlockState(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        if (this.world.isOutsideBuildHeight(pos)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        ChunkAccess ichunk = this.getChunk(pos);
        return ichunk.getFluidState(pos);
    }

    public int getHeight() {
        return this.world.getHeight();
    }

    public int getMinBuildHeight() {
        return this.world.getMinBuildHeight();
    }
}

