/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.api.universal_sensor.IPollSensorSetting;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.inventory.UniversalSensorMenu;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldGlobalVariableSensor
implements IPollSensorSetting {
    protected UUID playerID;

    @Override
    public String getSensorPath() {
        return "World/Global variable";
    }

    @Override
    public Set<PNCUpgrade> getRequiredUpgrades() {
        return ImmutableSet.of((Object)ModUpgrades.DISPENSER.get());
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public int getPollFrequency(BlockEntity te) {
        return 1;
    }

    @Override
    public int getRedstoneValue(Level level, BlockPos pos, int sensorRange, String textBoxText) {
        return GlobalVariableHelper.getInstance().getBool(this.playerID, textBoxText) ? 15 : 0;
    }

    @Override
    public void getAdditionalInfo(List<Component> info) {
        info.add((Component)Component.literal((String)"Variable Name"));
    }

    @Override
    public void setPlayerContext(UUID playerID) {
        this.playerID = playerID;
    }

    @Override
    public List<String> getTextBoxOptions(Player player) {
        List<String> list;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof UniversalSensorMenu) {
            UniversalSensorMenu c = (UniversalSensorMenu)abstractContainerMenu;
            list = c.getGlobalVars();
        } else {
            list = null;
        }
        return list;
    }
}

