/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.lang.reflect.Field;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SyncedField<T> {
    private final Field field;
    private final Object syncableObject;
    private final FieldType fieldType;
    private T lastValue;
    private int arrayIndex = -1;
    private boolean isLazy;

    SyncedField(Object syncableObject, Field field, FieldType fieldType) {
        this.syncableObject = syncableObject;
        this.field = field;
        field.setAccessible(true);
        this.fieldType = fieldType;
    }

    SyncedField<T> setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
        return this;
    }

    public SyncedField<T> setLazy(boolean lazy) {
        this.isLazy = lazy;
        return this;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String toString() {
        return this.arrayIndex == -1 ? "[" + String.valueOf(this.syncableObject) + "/" + this.field.getName() + "=" + String.valueOf(this.getValue()) + "]" : "[" + String.valueOf(this.syncableObject) + "/" + this.field.getName() + "[" + this.arrayIndex + "]=" + String.valueOf(this.getValue()) + "]";
    }

    public boolean update() {
        try {
            T value;
            T t = value = this.arrayIndex >= 0 ? this.getValueForArray(this.field.get(this.syncableObject), this.arrayIndex) : this.retrieveValue(this.field, this.syncableObject);
            if (this.lastValue == null && value != null || this.lastValue != null && !this.equals(this.lastValue, value)) {
                this.lastValue = value == null ? null : this.copyWhenNecessary(value);
                return !this.isLazy;
            }
        }
        catch (Throwable e) {
            Log.error("A problem occurred when trying to sync the field of {}. Field: {}, error: {}", this.syncableObject.toString(), this.field.toString(), e.getMessage());
        }
        return false;
    }

    protected boolean equals(T oldValue, T newValue) {
        return oldValue.equals(newValue);
    }

    protected T copyWhenNecessary(T oldValue) {
        return oldValue;
    }

    protected T retrieveValue(Field field, Object te) throws Exception {
        return (T)field.get(te);
    }

    protected void injectValue(Field field, Object te, T value) throws Exception {
        field.set(te, value);
    }

    protected abstract T getValueForArray(Object var1, int var2);

    protected abstract void setValueForArray(Object var1, int var2, T var3);

    public T getValue() {
        return this.lastValue;
    }

    private void setValueInternal(T value) {
        try {
            if (this.arrayIndex >= 0) {
                this.setValueForArray(this.field.get(this.syncableObject), this.arrayIndex, value);
            } else {
                this.injectValue(this.field, this.syncableObject, value);
            }
        }
        catch (Exception e) {
            Log.error("A problem occurred when trying to sync the field of {}. Field: {}, error: {}", this.syncableObject.toString(), this.field.toString(), e.getMessage());
        }
    }

    public void setValue(Object value) {
        this.setValueInternal(value);
    }

    static Object fromBytes(RegistryFriendlyByteBuf buf, FieldType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> buf.readInt();
            case 1 -> Float.valueOf(buf.readFloat());
            case 2 -> buf.readDouble();
            case 3 -> buf.readBoolean();
            case 4 -> buf.readUtf();
            case 5 -> buf.readByte();
            case 6 -> (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            case 7 -> (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            case 8 -> {
                int len = buf.readVarInt();
                ItemStackHandler handler = new ItemStackHandler(len);
                for (int i = 0; i < len; ++i) {
                    handler.setStackInSlot(buf.readVarInt(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
                }
                yield handler;
            }
        };
    }

    static void toBytes(RegistryFriendlyByteBuf buf, Object value, FieldType type) {
        switch (type.ordinal()) {
            case 0: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case 1: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case 2: {
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 3: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 4: {
                buf.writeUtf((String)value);
                break;
            }
            case 5: {
                buf.writeByte(((Byte)value).byteValue());
                break;
            }
            case 6: {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)(value == null ? ItemStack.EMPTY : (ItemStack)value));
                break;
            }
            case 7: {
                FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)((FluidStack)value));
                break;
            }
            case 8: {
                ItemStackHandler h = (ItemStackHandler)value;
                buf.writeVarInt(h.getSlots());
                for (int i = 0; i < h.getSlots(); ++i) {
                    buf.writeVarInt(i);
                    ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)h.getStackInSlot(i));
                }
                break;
            }
        }
    }

    public static enum FieldType {
        SYNCED_INT,
        SYNCED_FLOAT,
        SYNCED_DOUBLE,
        SYNCED_BOOL,
        SYNCED_STRING,
        SYNCED_ENUM,
        SYNCED_ITEMSTACK,
        SYNCED_FLUIDSTACK,
        SYNCED_ITEM_HANDLER;

    }

    public static class SyncedItemHandler
    extends SyncedField<IItemHandlerModifiable> {
        SyncedItemHandler(Object te, Field field) {
            super(te, field, FieldType.SYNCED_ITEM_HANDLER);
        }

        @Override
        protected ItemStackHandler getValueForArray(Object array, int index) {
            return ((ItemStackHandler[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, IItemHandlerModifiable value) {
            ((IItemHandlerModifiable[])array)[index] = value;
        }

        @Override
        protected IItemHandlerModifiable retrieveValue(Field field, Object te) throws Exception {
            return (IItemHandlerModifiable)field.get(te);
        }

        @Override
        protected void injectValue(Field field, Object te, IItemHandlerModifiable value) throws Exception {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)field.get(te);
            for (int i = 0; i < value.getSlots(); ++i) {
                handler.setStackInSlot(i, value.getStackInSlot(i));
            }
        }

        @Override
        protected boolean equals(IItemHandlerModifiable oldValue, IItemHandlerModifiable newValue) {
            if (oldValue.getSlots() != newValue.getSlots()) {
                return false;
            }
            for (int i = 0; i < oldValue.getSlots(); ++i) {
                if (ItemStack.matches((ItemStack)oldValue.getStackInSlot(i), (ItemStack)newValue.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected IItemHandlerModifiable copyWhenNecessary(IItemHandlerModifiable oldValue) {
            ItemStackHandler result = new ItemStackHandler(oldValue.getSlots());
            for (int i = 0; i < oldValue.getSlots(); ++i) {
                ItemStack stack = oldValue.getStackInSlot(i);
                result.setStackInSlot(i, stack.isEmpty() ? ItemStack.EMPTY : stack.copy());
            }
            return result;
        }
    }

    public static class SyncedFluidStack
    extends SyncedField<FluidStack> {
        SyncedFluidStack(Object te, Field field) {
            super(te, field, FieldType.SYNCED_FLUIDSTACK);
        }

        @Override
        protected FluidStack getValueForArray(Object array, int index) {
            return ((FluidStack[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, FluidStack value) {
            ((FluidStack[])array)[index] = value;
        }

        @Override
        protected boolean equals(FluidStack oldValue, FluidStack newValue) {
            return FluidStack.matches((FluidStack)oldValue, (FluidStack)newValue);
        }

        @Override
        protected FluidStack copyWhenNecessary(FluidStack oldValue) {
            return oldValue.copy();
        }
    }

    public static class SyncedItemStack
    extends SyncedField<ItemStack> {
        SyncedItemStack(Object te, Field field) {
            super(te, field, FieldType.SYNCED_ITEMSTACK);
        }

        @Override
        protected ItemStack getValueForArray(Object array, int index) {
            return ((ItemStack[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, ItemStack value) {
            ((ItemStack[])array)[index] = value;
        }

        @Override
        protected boolean equals(ItemStack oldValue, ItemStack newValue) {
            return ItemStack.matches((ItemStack)oldValue, (ItemStack)newValue);
        }

        @Override
        protected ItemStack copyWhenNecessary(ItemStack oldValue) {
            return oldValue.copy();
        }
    }

    public static class SyncedEnum
    extends SyncedField<Byte> {
        SyncedEnum(Object te, Field field) {
            super(te, field, FieldType.SYNCED_ENUM);
        }

        @Override
        protected Byte getValueForArray(Object array, int index) {
            return ((byte[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Byte value) {
            ((byte[])array)[index] = value;
        }

        @Override
        protected Byte retrieveValue(Field field, Object te) throws Exception {
            Object[] enumTypes = field.getType().getEnumConstants();
            return (byte)ArrayUtils.indexOf((Object[])enumTypes, (Object)field.get(te));
        }

        @Override
        protected void injectValue(Field field, Object te, Byte value) throws Exception {
            if (value == -1) {
                field.set(te, null);
            } else {
                Object enumType = field.getType().getEnumConstants()[value];
                field.set(te, enumType);
            }
        }
    }

    public static class SyncedString
    extends SyncedField<String> {
        SyncedString(Object te, Field field) {
            super(te, field, FieldType.SYNCED_STRING);
        }

        @Override
        protected String getValueForArray(Object array, int index) {
            return ((String[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, String value) {
            ((String[])array)[index] = value;
        }
    }

    public static class SyncedBoolean
    extends SyncedField<Boolean> {
        SyncedBoolean(Object te, Field field) {
            super(te, field, FieldType.SYNCED_BOOL);
        }

        @Override
        protected Boolean getValueForArray(Object array, int index) {
            return ((boolean[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Boolean value) {
            ((boolean[])array)[index] = value;
        }
    }

    public static class SyncedDouble
    extends SyncedField<Double> {
        SyncedDouble(Object te, Field field) {
            super(te, field, FieldType.SYNCED_DOUBLE);
        }

        @Override
        protected Double getValueForArray(Object array, int index) {
            return ((double[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Double value) {
            ((double[])array)[index] = value;
        }
    }

    public static class SyncedFloat
    extends SyncedField<Float> {
        SyncedFloat(Object te, Field field) {
            super(te, field, FieldType.SYNCED_FLOAT);
        }

        @Override
        protected Float getValueForArray(Object array, int index) {
            return Float.valueOf(((float[])array)[index]);
        }

        @Override
        protected void setValueForArray(Object array, int index, Float value) {
            ((float[])array)[index] = value.floatValue();
        }
    }

    public static class SyncedInt
    extends SyncedField<Integer> {
        public SyncedInt(Object te, Field field) {
            super(te, field, FieldType.SYNCED_INT);
        }

        @Override
        protected Integer getValueForArray(Object array, int index) {
            return ((int[])array)[index];
        }

        @Override
        protected void setValueForArray(Object array, int index, Integer value) {
            ((int[])array)[index] = value;
        }
    }
}

