/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateTextfield(int textFieldID, String text) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateTextfield> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_textfield"));
    public static final StreamCodec<FriendlyByteBuf, PacketUpdateTextfield> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PacketUpdateTextfield::textFieldID, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketUpdateTextfield::text, PacketUpdateTextfield::new);

    public static PacketUpdateTextfield create(IGUITextFieldSensitive sensitive, int id) {
        return new PacketUpdateTextfield(id, sensitive.getText(id));
    }

    public CustomPacketPayload.Type<PacketUpdateTextfield> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateTextfield message, IPayloadContext ctx) {
        PacketUtil.getBlockEntity(ctx.player(), BlockEntity.class).ifPresent(te -> {
            if (te instanceof IGUITextFieldSensitive) {
                IGUITextFieldSensitive sensitive = (IGUITextFieldSensitive)te;
                sensitive.setText(message.textFieldID(), message.text());
            }
        });
    }
}

