/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.RemoteItem;
import me.desht.pneumaticcraft.common.remote.SavedRemoteLayout;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateRemoteLayout(SavedRemoteLayout layout, InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUpdateRemoteLayout> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("update_remote_layout"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateRemoteLayout> STREAM_CODEC = StreamCodec.composite(SavedRemoteLayout.STREAM_CODEC, PacketUpdateRemoteLayout::layout, (StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), PacketUpdateRemoteLayout::hand, PacketUpdateRemoteLayout::new);

    public CustomPacketPayload.Type<PacketUpdateRemoteLayout> type() {
        return TYPE;
    }

    public static void handle(PacketUpdateRemoteLayout message, IPayloadContext ctx) {
        ItemStack remote = ctx.player().getItemInHand(message.hand);
        if (remote.getItem() instanceof RemoteItem) {
            RemoteItem.saveToItem(remote, message.layout);
        }
    }
}

