/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketAphorismTileUpdate(BlockPos pos, List<String> text, int textRotation, byte margin, boolean invis, int playerId) implements CustomPacketPayload
{
    private static final int MAX_LENGTH = 1024;
    public static final CustomPacketPayload.Type<PacketAphorismTileUpdate> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("aphorism_tile_update"));
    public static final StreamCodec<FriendlyByteBuf, PacketAphorismTileUpdate> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketAphorismTileUpdate::pos, (StreamCodec)ByteBufCodecs.stringUtf8((int)1024).apply(ByteBufCodecs.list()), PacketAphorismTileUpdate::text, (StreamCodec)ByteBufCodecs.VAR_INT, PacketAphorismTileUpdate::textRotation, (StreamCodec)ByteBufCodecs.BYTE, PacketAphorismTileUpdate::margin, (StreamCodec)ByteBufCodecs.BOOL, PacketAphorismTileUpdate::invis, (StreamCodec)ByteBufCodecs.INT, PacketAphorismTileUpdate::playerId, PacketAphorismTileUpdate::new);

    public static PacketAphorismTileUpdate forBlockEntity(AphorismTileBlockEntity blockEntity) {
        return new PacketAphorismTileUpdate(blockEntity.getBlockPos(), List.of(blockEntity.getTextLines()), blockEntity.getTextRotation(), blockEntity.getMarginSize(), (Boolean)blockEntity.getBlockState().getValue((Property)AphorismTileBlock.INVISIBLE), 0);
    }

    public static PacketAphorismTileUpdate forBlockEntityAndPlayer(AphorismTileBlockEntity blockEntity, Player player) {
        return new PacketAphorismTileUpdate(blockEntity.getBlockPos(), List.of(blockEntity.getTextLines()), blockEntity.getTextRotation(), blockEntity.getMarginSize(), (Boolean)blockEntity.getBlockState().getValue((Property)AphorismTileBlock.INVISIBLE), player.getId());
    }

    public CustomPacketPayload.Type<PacketAphorismTileUpdate> type() {
        return TYPE;
    }

    public static void handle(PacketAphorismTileUpdate message, IPayloadContext ctx) {
        AphorismTileBlockEntity tile;
        Player player = ctx.player();
        if (ctx.flow().isClientbound()) {
            if (message.playerId != player.getId()) {
                PacketAphorismTileUpdate.updateAphorismTile(message, player);
            }
        } else if (PneumaticCraftUtils.canPlayerReach(player, message.pos()) && (tile = PacketAphorismTileUpdate.updateAphorismTile(message, player)) != null) {
            NetworkHandler.sendToAllTracking(PacketAphorismTileUpdate.forBlockEntityAndPlayer(tile, player), player.level(), message.pos);
        }
    }

    private static AphorismTileBlockEntity updateAphorismTile(PacketAphorismTileUpdate message, Player player) {
        return PneumaticCraftUtils.getBlockEntityAt((BlockGetter)player.level(), message.pos(), AphorismTileBlockEntity.class).map(tile -> {
            tile.setTextLines(message.text().toArray(new String[0]), false);
            tile.setTextRotation(message.textRotation());
            tile.setMarginSize(message.margin());
            tile.setInvisible(message.invis());
            return tile;
        }).orElse(null);
    }
}

