/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketAmadronOrderUpdate(ResourceLocation orderId, int mouseButton, boolean sneaking) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketAmadronOrderUpdate> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("amadron_order_update"));
    public static final StreamCodec<FriendlyByteBuf, PacketAmadronOrderUpdate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PacketAmadronOrderUpdate::orderId, (StreamCodec)ByteBufCodecs.VAR_INT, PacketAmadronOrderUpdate::mouseButton, (StreamCodec)ByteBufCodecs.BOOL, PacketAmadronOrderUpdate::sneaking, PacketAmadronOrderUpdate::new);

    public CustomPacketPayload.Type<PacketAmadronOrderUpdate> type() {
        return TYPE;
    }

    public static void handle(PacketAmadronOrderUpdate message, IPayloadContext ctx) {
        Player player = ctx.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player = sp.containerMenu;
            if (player instanceof AmadronMenu) {
                AmadronMenu menu = (AmadronMenu)player;
                menu.clickOffer(message.orderId(), message.mouseButton(), message.sneaking(), sp);
            }
        }
    }
}

