/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ManometerItem
extends PressurizableItem {
    public ManometerItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        return PNCCapabilities.getAirHandler(stack).map(h -> {
            BlockEntity te;
            if (h.getAir() < 30) {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", stack.getHoverName()).withStyle(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            ArrayList<Component> curInfo = new ArrayList<Component>();
            Direction side = context.getClickedFace();
            BlockPos pos = context.getClickedPos();
            BlockState state = world.getBlockState(pos.relative(side));
            if (!player.isShiftKeyDown() && state.getBlock() instanceof LiquidBlock) {
                pos = pos.relative(side);
            }
            if ((te = world.getBlockEntity(pos)) != null) {
                TemperatureData tempData;
                if (te instanceof Nameable) {
                    curInfo.add((Component)((Nameable)te).getDisplayName().copy().withStyle(ChatFormatting.AQUA));
                } else {
                    curInfo.add((Component)PneumaticCraftUtils.xlate(te.getBlockState().getBlock().getDescriptionId(), new Object[0]).withStyle(ChatFormatting.AQUA));
                }
                PNCCapabilities.getAirHandler(te).ifPresentOrElse(handler -> handler.printManometerMessage(player, curInfo), () -> PNCCapabilities.getAirHandler(te, side).ifPresent(handler -> handler.printManometerMessage(player, curInfo)));
                if (te instanceof IManoMeasurable) {
                    ((IManoMeasurable)te).printManometerMessage(player, curInfo);
                }
                if ((tempData = TemperatureData.forBlockEntity(te)).isMultisided()) {
                    for (Direction face : DirectionUtil.VALUES) {
                        if (!tempData.hasData(face)) continue;
                        curInfo.add(HeatUtil.formatHeatString(face, tempData.getTemperatureAsInt(face)));
                    }
                } else if (tempData.hasData(null)) {
                    curInfo.add(HeatUtil.formatHeatString(tempData.getTemperatureAsInt(null)));
                } else {
                    HeatExchangerManager.getInstance().getLogic(world, pos, side).ifPresent(logic -> curInfo.add(HeatUtil.formatHeatString((int)logic.getTemperature())));
                }
            } else {
                BlockState state1 = world.getBlockState(pos);
                Block patt0$temp = state1.getBlock();
                if (patt0$temp instanceof LiquidBlock) {
                    LiquidBlock liquidBlock = (LiquidBlock)patt0$temp;
                    FlowingFluid f = liquidBlock.fluid;
                    FluidStack fs = new FluidStack((Fluid)f, 1000);
                    curInfo.add((Component)fs.getHoverName().copy().withStyle(ChatFormatting.AQUA));
                } else {
                    curInfo.add((Component)PneumaticCraftUtils.xlate(world.getBlockState(pos).getBlock().getDescriptionId(), new Object[0]).withStyle(ChatFormatting.AQUA));
                }
                HeatExchangerManager.INSTANCE.getLogic(world, pos, side).ifPresent(logic -> curInfo.add(HeatUtil.formatHeatString(logic.getTemperatureAsInt())));
            }
            this.checkForHeatExtraction(world, pos, curInfo);
            if (!curInfo.isEmpty()) {
                for (int i = 1; i < curInfo.size(); ++i) {
                    curInfo.set(i, (Component)Symbols.bullet().append((Component)curInfo.get(i)));
                }
                curInfo.forEach(s -> player.displayClientMessage(s, false));
                if (!player.isCreative()) {
                    h.addAir(-30);
                }
            }
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    private void checkForHeatExtraction(Level world, BlockPos pos, List<Component> curInfo) {
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te1 = world.getBlockEntity(pos.relative(d));
            if (te1 == null) continue;
            PNCCapabilities.getHeatLogic(te1, d.getOpposite()).flatMap(handler -> handler.getHeatBehaviour(pos, HeatBehaviourTransition.class)).ifPresent(behaviour -> {
                double progress = behaviour.getExtractionProgress();
                if (progress != 0.0) {
                    String key = "pneumaticcraft.waila.temperature" + (progress < 0.0 ? "Gain" : "Loss");
                    int pct = progress < 0.0 ? (int)(progress * -100.0) : (int)(progress * 100.0);
                    curInfo.add((Component)Component.translatable((String)key, (Object[])new Object[]{pct}));
                }
            });
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        return PNCCapabilities.getAirHandler(stack).map(h -> {
            if (h.getPressure() >= 0.1f) {
                double temp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)worldIn, playerIn.blockPosition());
                playerIn.displayClientMessage((Component)ItemStack.EMPTY.getHoverName().copy().withStyle(ChatFormatting.AQUA), false);
                playerIn.displayClientMessage((Component)Symbols.bullet().append(HeatUtil.formatHeatString((int)temp)), false);
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }).orElse(InteractionResultHolder.pass((Object)stack));
    }

    public InteractionResult interactLivingEntity(ItemStack iStack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!player.level().isClientSide) {
            return PNCCapabilities.getAirHandler(iStack).map(h -> {
                if (h.getAir() < 30) {
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.outOfAir", iStack.getHoverName()).withStyle(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                ArrayList<Component> curInfo = new ArrayList<Component>();
                if (entity instanceof IManoMeasurable) {
                    ((IManoMeasurable)entity).printManometerMessage(player, curInfo);
                } else {
                    curInfo.add((Component)entity.getDisplayName().copy().withStyle(ChatFormatting.AQUA));
                }
                if (!curInfo.isEmpty()) {
                    h.addAir(-30);
                    for (int i = 1; i < curInfo.size(); ++i) {
                        curInfo.set(i, (Component)Symbols.bullet().append((Component)curInfo.get(i)));
                    }
                    curInfo.forEach(s -> player.displayClientMessage(s, false));
                }
                return InteractionResult.SUCCESS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.SUCCESS;
    }
}

