/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ChargingStationMenu
extends AbstractPneumaticCraftMenu<ChargingStationBlockEntity> {
    public ChargingStationMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, ChargingStationMenu.getTilePos(buffer));
    }

    public ChargingStationMenu(int i, Inventory inventoryPlayer, BlockPos pos) {
        super(ModMenuTypes.CHARGING_STATION.get(), i, inventoryPlayer, pos);
        this.addSlot((Slot)new SlotItemHandler(this, ((ChargingStationBlockEntity)this.blockEntity).getItemHandler(), 0, 91, 45){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addUpgradeSlots(42, 35);
        this.addArmorSlots(inventoryPlayer, 8, 25);
        this.addOffhandSlot(inventoryPlayer, 28, 79);
        this.addPlayerSlots(inventoryPlayer, 101);
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        Slot srcSlot = (Slot)this.slots.get(slot);
        if (srcSlot == null || !srcSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack srcStack = srcSlot.getItem().copy();
        ItemStack copyOfSrcStack = srcStack.copy();
        if (slot == 0 && srcStack.getItem() instanceof ArmorItem ? !this.moveItemStackTo(srcStack, 5, 9, false) && !this.moveItemStackToHotbarOrInventory(srcStack, this.playerSlotsStart) : (slot >= 5 && slot < 9 && PNCCapabilities.getAirHandler(srcStack).isPresent() ? !this.moveItemStackTo(srcStack, 0, 1, false) && !this.moveItemStackTo(srcStack, this.playerSlotsStart, this.playerSlotsStart + 36, false) : (slot < this.playerSlotsStart ? !this.moveItemStackToHotbarOrInventory(srcStack, this.playerSlotsStart) : !this.moveItemStackTo(srcStack, 0, this.playerSlotsStart, false)))) {
            return ItemStack.EMPTY;
        }
        srcSlot.set(srcStack);
        srcSlot.onQuickCraft(srcStack, copyOfSrcStack);
        srcSlot.onTake(player, srcStack);
        return copyOfSrcStack;
    }
}

