/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.AbstractPersistentEntityHack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class HackableBlaze
extends AbstractPersistentEntityHack<Blaze> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("blaze");

    public HackableBlaze() {
        super(AbstractPersistentEntityHack.StockHackTypes.DISARM);
    }

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    public Class<Blaze> getHackableClass() {
        return Blaze.class;
    }

    @Override
    public void onHackFinished(Blaze entity, Player player) {
        super.onHackFinished(entity, player);
        entity.setSilent(true);
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onFireball(EntityJoinLevelEvent event) {
            Blaze blaze;
            SmallFireball f;
            Entity entity = event.getEntity();
            if (entity instanceof SmallFireball && (entity = (f = (SmallFireball)entity).getOwner()) instanceof Blaze && AbstractPersistentEntityHack.hasPersistentHack(blaze = (Blaze)entity, HackableBlaze.class)) {
                event.setCanceled(true);
            }
        }
    }
}

