/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.item.logistics.AbstractLogisticsFrameItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.FluidFilter;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class AbstractLogisticsFrameEntity
extends AbstractSemiblockEntity
implements IDirectionalSemiblock {
    public static final String NBT_INVISIBLE = "invisible";
    public static final String NBT_MATCH_COMPONENTS = "matchComponents";
    public static final String NBT_MATCH_DURABILITY = "matchDurability";
    public static final String NBT_MATCH_MODID = "matchModID";
    public static final String NBT_ITEM_WHITELIST = "whitelist";
    public static final String NBT_FLUID_WHITELIST = "fluidWhitelist";
    public static final String NBT_ITEM_FILTERS = "filters";
    public static final String NBT_FLUID_FILTERS = "fluidFilters";
    private static final String NBT_SIDE = "side";
    private static final int ITEM_FILTER_SLOTS = 27;
    public static final int FLUID_FILTER_SLOTS = 9;
    private static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.defineId(AbstractLogisticsFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Direction> SIDE = SynchedEntityData.defineId(AbstractLogisticsFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final float FRAME_WIDTH = 0.03125f;
    private final Map<ItemStack, Integer> incomingStacks = new HashMap<ItemStack, Integer>();
    private final Map<FluidStack, Integer> incomingFluid = new IdentityHashMap<FluidStack, Integer>();
    private final ItemFilterHandler itemFilterHandler = new ItemFilterHandler(27);
    private FluidFilter fluidFilter = new FluidFilter(9);
    private boolean matchComponents = false;
    private boolean matchDurability = false;
    private boolean matchModId = false;
    private boolean itemWhiteList = false;
    private boolean fluidWhiteList = false;
    private int alpha = 255;

    AbstractLogisticsFrameEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static AbstractLogisticsFrameEntity fromItemStack(Level world, @Nullable Player player, @Nonnull ItemStack stack) {
        SemiblockItem semiblockItem;
        AbstractSemiblockEntity semiblock;
        Item item = stack.getItem();
        if (item instanceof SemiblockItem && (semiblock = (semiblockItem = (SemiblockItem)item).createEntity(world, stack, player, BlockPos.ZERO)) instanceof AbstractLogisticsFrameEntity) {
            AbstractLogisticsFrameEntity logisticsFrame = (AbstractLogisticsFrameEntity)semiblock;
            if (world.isClientSide && stack.has(ModDataComponents.SEMIBLOCK_DATA)) {
                CompoundTag tag = logisticsFrame.saveWithoutId(new CompoundTag());
                UUID uuid = logisticsFrame.getUUID();
                CompoundTag toMerge = ((CustomData)stack.get(ModDataComponents.SEMIBLOCK_DATA)).copyTag();
                tag.merge(toMerge);
                logisticsFrame.setUUID(uuid);
                logisticsFrame.load(tag);
            }
            return logisticsFrame;
        }
        return null;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INVISIBLE, (Object)false);
        builder.define(SIDE, (Object)Direction.SOUTH);
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockEntity te = this.getCachedTileEntity();
        return te != null && (IOHelper.getInventoryForBlock(te, facing).isPresent() || IOHelper.getFluidHandlerForBlock(te, facing).isPresent());
    }

    @Override
    public boolean canStay() {
        return this.canPlace(this.getSide());
    }

    @Override
    protected AABB calculateBlockBounds() {
        AABB bb = super.calculateBlockBounds();
        return switch (this.getSide()) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new AABB(bb.minX, bb.minY - 0.03125, bb.minZ, bb.maxX, bb.minY, bb.maxZ);
            case Direction.UP -> new AABB(bb.minX, bb.maxY, bb.minZ, bb.maxX, bb.maxY + 0.03125, bb.maxZ);
            case Direction.NORTH -> new AABB(bb.minX, bb.minY, bb.minZ - 0.03125, bb.maxX, bb.maxY, bb.minZ);
            case Direction.SOUTH -> new AABB(bb.minX, bb.minY, bb.maxZ, bb.maxX, bb.maxY, bb.maxZ + 0.03125);
            case Direction.WEST -> new AABB(bb.minX - 0.03125, bb.minY, bb.minZ, bb.minX, bb.maxY, bb.maxZ);
            case Direction.EAST -> new AABB(bb.maxX, bb.minY, bb.minZ, bb.maxX + 0.03125, bb.maxY, bb.maxZ);
        };
    }

    @Override
    public abstract int getColor();

    public abstract ResourceLocation getTexture();

    public abstract int getPriority();

    protected abstract MenuType<?> getContainerType();

    public boolean shouldProvideTo(int level) {
        return true;
    }

    public boolean isSemiblockInvisible() {
        return (Boolean)this.getEntityData().get(INVISIBLE);
    }

    public void setSemiblockInvisible(boolean invisible) {
        this.getEntityData().set(INVISIBLE, (Object)invisible);
    }

    @Override
    public Direction getSide() {
        return (Direction)this.getEntityData().get(SIDE);
    }

    @Override
    public void setSide(Direction facing) {
        if (SemiblockTracker.getInstance().getSemiblock(this.level(), this.getBlockPos(), facing) == null) {
            this.getEntityData().set(SIDE, (Object)facing);
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean isItemWhiteList() {
        return this.itemWhiteList;
    }

    public void setItemWhiteList(boolean whiteList) {
        this.itemWhiteList = whiteList;
    }

    public boolean isFluidWhiteList() {
        return this.fluidWhiteList;
    }

    public void setFluidWhiteList(boolean whiteList) {
        this.fluidWhiteList = whiteList;
    }

    public boolean isMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }

    public boolean isMatchDurability() {
        return this.matchDurability;
    }

    public void setMatchDurability(boolean matchDurability) {
        this.matchDurability = matchDurability;
    }

    public boolean isMatchModId() {
        return this.matchModId;
    }

    public void setMatchModId(boolean matchModId) {
        this.matchModId = matchModId;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Iterator<Map.Entry<ItemStack, Integer>> iterator = this.incomingStacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> entry = iterator.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
            Iterator<Map.Entry<FluidStack, Integer>> it = this.incomingFluid.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<FluidStack, Integer> entry = it.next();
                int counter = entry.getValue();
                if (counter > 10) {
                    it.remove();
                    continue;
                }
                entry.setValue(counter + 1);
            }
        } else {
            this.alpha = this.isSemiblockInvisible() && !this.isClientPlayerHoldingLogisticItems() ? Math.max(0, this.alpha - 9) : Math.min(255, this.alpha + 9);
        }
    }

    public void informIncomingStack(ItemStack stack) {
        this.incomingStacks.put(stack, 0);
    }

    public void clearIncomingStack(ItemStack stack) {
        this.incomingStacks.remove(stack);
    }

    public void informIncomingStack(FluidStack stack) {
        this.incomingFluid.put(stack, 0);
    }

    public void clearIncomingStack(FluidStack stack) {
        this.incomingFluid.remove(stack);
    }

    public int getIncomingFluid(Fluid fluid) {
        int count = 0;
        for (FluidStack fluidStack : this.incomingFluid.keySet()) {
            if (fluidStack.getFluid() != fluid) continue;
            count += fluidStack.getAmount();
        }
        return count;
    }

    public int getIncomingItems(ItemStack stack) {
        return this.incomingStacks.keySet().stream().filter(s -> this.itemFilterHandler.matchOneItem(stack, (ItemStack)s)).mapToInt(ItemStack::getCount).sum();
    }

    public void setItemFilter(int slot, ItemStack stack) {
        this.itemFilterHandler.setStackInSlot(slot, stack);
    }

    public void setFluidFilter(int filterIndex, FluidStack stack) {
        this.fluidFilter.setFluid(filterIndex, stack);
    }

    public FluidStack getFluidFilter(int filterIndex) {
        return this.fluidFilter.getFluid(filterIndex);
    }

    public ItemFilterHandler getItemFilterHandler() {
        return this.itemFilterHandler;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.itemFilterHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), tag.getCompound(NBT_ITEM_FILTERS));
        this.fluidFilter = FluidFilter.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound(NBT_FLUID_FILTERS)).result().orElse(new FluidFilter(9));
        this.setSemiblockInvisible(tag.getBoolean(NBT_INVISIBLE));
        this.setMatchComponents(tag.getBoolean(NBT_MATCH_COMPONENTS));
        this.setMatchDurability(tag.getBoolean(NBT_MATCH_DURABILITY));
        this.setMatchModId(tag.getBoolean(NBT_MATCH_MODID));
        this.setItemWhiteList(tag.getBoolean(NBT_ITEM_WHITELIST));
        this.setFluidWhiteList(tag.getBoolean(NBT_FLUID_WHITELIST));
        this.setSide(tag.contains(NBT_SIDE) ? Direction.from3DDataValue((int)tag.getInt(NBT_SIDE)) : Direction.UP);
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity = this;
        if (abstractLogisticsFrameEntity instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            spr.setMinItemOrderSize(Math.max(1, tag.getInt("minItems")));
            spr.setMinFluidOrderSize(Math.max(1, tag.getInt("minFluid")));
        }
    }

    @Override
    public CompoundTag serializeNBT(CompoundTag tag, HolderLookup.Provider provider) {
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity;
        CompoundTag tag1 = super.serializeNBT(tag, provider);
        tag1.put(NBT_ITEM_FILTERS, (Tag)this.itemFilterHandler.serializeNBT(provider));
        FluidFilter.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.fluidFilter).ifSuccess(t -> tag1.put(NBT_FLUID_FILTERS, t));
        tag1.put(NBT_FLUID_FILTERS, (Tag)FluidFilter.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.fluidFilter).result().orElse(new CompoundTag()));
        if (this.isSemiblockInvisible()) {
            tag1.putBoolean(NBT_INVISIBLE, true);
        }
        if (this.isMatchComponents()) {
            tag1.putBoolean(NBT_MATCH_COMPONENTS, true);
        }
        if (this.isMatchDurability()) {
            tag1.putBoolean(NBT_MATCH_DURABILITY, true);
        }
        if (this.isMatchModId()) {
            tag1.putBoolean(NBT_MATCH_MODID, true);
        }
        if (this.isItemWhiteList()) {
            tag1.putBoolean(NBT_ITEM_WHITELIST, true);
        }
        if (this.isFluidWhiteList()) {
            tag1.putBoolean(NBT_FLUID_WHITELIST, true);
        }
        if (this.getSide() != null) {
            tag1.putInt(NBT_SIDE, this.getSide().get3DDataValue());
        }
        if ((abstractLogisticsFrameEntity = this) instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            tag1.putInt("minItems", spr.getMinItemOrderSize());
            tag1.putInt("minFluid", spr.getMinFluidOrderSize());
        }
        return tag1;
    }

    @Override
    public void onPlaced(Player player, ItemStack stack, Direction facing) {
        super.onPlaced(player, stack, facing);
        this.setSide(facing);
    }

    public boolean canFilterStack() {
        return false;
    }

    boolean passesFilter(ItemStack stack) {
        return this.itemFilterHandler.match(stack) == this.isItemWhiteList();
    }

    boolean passesFilter(Fluid fluid) {
        return this.fluidFilter.matchFluid(fluid) == this.isFluidWhiteList();
    }

    @Override
    public void addTooltip(Consumer<Component> curInfo, Player player, CompoundTag tag, boolean extended) {
        NonNullList<ItemStack> drops;
        MutableComponent dir = Component.translatable((String)("pneumaticcraft.gui.tooltip.direction." + this.getSide().getName()));
        curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.facing", dir));
        if (player.isShiftKeyDown() && !(drops = this.getDrops()).isEmpty()) {
            AbstractLogisticsFrameItem.addLogisticsTooltip((ItemStack)drops.getFirst(), Item.TooltipContext.of((Level)player.level()), new ArrayList<Component>(), true).forEach(curInfo);
        }
    }

    @Override
    public boolean onRightClickWithConfigurator(Player player, Direction side) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (side != this.getSide()) {
                return false;
            }
            MenuProvider provider = new MenuProvider(){

                public Component getDisplayName() {
                    return new ItemStack((ItemLike)AbstractLogisticsFrameEntity.this.getDroppedItem()).getHoverName();
                }

                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new LogisticsMenu(AbstractLogisticsFrameEntity.this.getContainerType(), i, playerInventory, AbstractLogisticsFrameEntity.this.getId());
                }
            };
            NetworkHandler.sendToPlayer(PacketSyncSemiblock.create(this, false, sp.registryAccess()), sp);
            sp.openMenu(provider, buffer -> buffer.writeVarInt(this.getId()));
        }
        return true;
    }

    private boolean isClientPlayerHoldingLogisticItems() {
        Player player = ClientUtils.getClientPlayer();
        ItemStack stack = player.getMainHandItem();
        return stack.getItem() == ModItems.LOGISTICS_CONFIGURATOR.get() || stack.getItem() == ModItems.LOGISTICS_DRONE.get() || stack.getItem() instanceof SemiblockItem;
    }

    public boolean supportsBlacklisting() {
        return true;
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf payload) {
        super.writeToBuf(payload);
        payload.writeByte(this.getSide().get3DDataValue());
        payload.writeBoolean(this.isSemiblockInvisible());
        payload.writeBoolean(this.itemWhiteList);
        payload.writeBoolean(this.fluidWhiteList);
        payload.writeBoolean(this.matchComponents);
        payload.writeBoolean(this.matchDurability);
        payload.writeBoolean(this.matchModId);
        payload.writeVarInt(this.itemFilterHandler.getSlots());
        for (int i = 0; i < this.itemFilterHandler.getSlots(); ++i) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)payload, (Object)this.itemFilterHandler.getStackInSlot(i));
        }
        FluidFilter.STREAM_CODEC.encode((Object)payload, (Object)this.fluidFilter);
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity = this;
        if (abstractLogisticsFrameEntity instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            payload.writeVarInt(spr.getMinItemOrderSize());
            payload.writeVarInt(spr.getMinFluidOrderSize());
        }
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf payload) {
        super.readFromBuf(payload);
        this.setSide(Direction.from3DDataValue((int)payload.readByte()));
        this.setSemiblockInvisible(payload.readBoolean());
        this.itemWhiteList = payload.readBoolean();
        this.fluidWhiteList = payload.readBoolean();
        this.matchComponents = payload.readBoolean();
        this.matchDurability = payload.readBoolean();
        this.matchModId = payload.readBoolean();
        int size = payload.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.itemFilterHandler.setStackInSlot(i, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)payload));
        }
        this.fluidFilter = (FluidFilter)FluidFilter.STREAM_CODEC.decode((Object)payload);
        AbstractLogisticsFrameEntity abstractLogisticsFrameEntity = this;
        if (abstractLogisticsFrameEntity instanceof ISpecificRequester) {
            ISpecificRequester spr = (ISpecificRequester)((Object)abstractLogisticsFrameEntity);
            spr.setMinItemOrderSize(payload.readVarInt());
            spr.setMinFluidOrderSize(payload.readVarInt());
        }
    }

    public boolean isObstructed(PathComputationType pathType) {
        BlockPos pos = this.getBlockPos().relative(this.getSide());
        return !this.level().getBlockState(pos).isPathfindable(pathType);
    }

    public class ItemFilterHandler
    extends ItemStackHandler {
        private final List<ItemStack> filterStacks;

        ItemFilterHandler(int size) {
            super(size);
            this.filterStacks = new ArrayList<ItemStack>();
        }

        boolean match(ItemStack stack) {
            return this.filterStacks.stream().anyMatch(filterStack -> this.matchOneItem((ItemStack)filterStack, stack));
        }

        int getMatchedCount(ItemStack stack) {
            return this.filterStacks.stream().filter(filterStack -> this.matchOneItem((ItemStack)filterStack, stack)).mapToInt(ItemStack::getCount).sum();
        }

        boolean matchOneItem(ItemStack filterStack, ItemStack stack) {
            return !filterStack.isEmpty() && PneumaticCraftUtils.doesItemMatchFilter(filterStack, stack, AbstractLogisticsFrameEntity.this.isMatchDurability(), AbstractLogisticsFrameEntity.this.isMatchComponents(), AbstractLogisticsFrameEntity.this.isMatchModId());
        }

        private void buildFilterList() {
            this.filterStacks.clear();
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).isEmpty()) continue;
                this.filterStacks.add(this.getStackInSlot(i));
            }
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            super.deserializeNBT(provider, nbt);
            this.buildFilterList();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.buildFilterList();
        }

        public boolean isEmpty() {
            return this.filterStacks.isEmpty();
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerLeftClick(AttackEntityEvent event) {
            AbstractLogisticsFrameEntity frame;
            Entity entity = event.getTarget();
            if (entity instanceof AbstractLogisticsFrameEntity && (frame = (AbstractLogisticsFrameEntity)entity).isSemiblockInvisible()) {
                frame.getBlockState().attack(frame.getWorld(), frame.getBlockPos(), event.getEntity());
                event.setCanceled(true);
            }
        }
    }
}

