/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class AreaTypeRandom
extends AreaType {
    public static final MapCodec<AreaTypeRandom> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("picked_amount").forGetter(t -> t.pickedAmount)).apply((Applicative)builder, AreaTypeRandom::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeRandom> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, t -> t.pickedAmount, AreaTypeRandom::new);
    public static final String ID = "random";
    private int pickedAmount;

    public AreaTypeRandom() {
        this(0);
    }

    public AreaTypeRandom(int pickedAmount) {
        super(ID);
        this.pickedAmount = pickedAmount;
    }

    @Override
    public AreaType copy() {
        return new AreaTypeRandom(this.pickedAmount);
    }

    public String toString() {
        return this.getName() + "/" + this.pickedAmount;
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_RANDOM.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int sx = maxX - minX + 1;
        int sy = maxY - minY + 1;
        int sz = maxZ - minZ + 1;
        int size = sx * sy * sz;
        if (this.pickedAmount >= size) {
            BlockPos.betweenClosedStream((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).forEach(pos -> areaAdder.accept(pos.immutable()));
        } else {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < this.pickedAmount; ++i) {
                int x = minX + ((Random)rand).nextInt(sx);
                int y = minY + ((Random)rand).nextInt(sy);
                int z = minZ + ((Random)rand).nextInt(sz);
                areaAdder.accept(new BlockPos(x, y, z));
            }
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.IntegerField("pneumaticcraft.gui.progWidget.area.type.random.blocksSelected", () -> this.pickedAmount, amount -> {
            this.pickedAmount = amount;
        }));
    }

    @Override
    public void convertFromLegacy(EnumOldAreaType oldAreaType, int typeInfo) {
        this.pickedAmount = typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeRandom that = (AreaTypeRandom)o;
        return this.pickedAmount == that.pickedAmount;
    }

    public int hashCode() {
        return Objects.hashCode(this.pickedAmount);
    }
}

